/*
 * Decompiled with CFR 0.152.
 */
package com.anf.ws.credential.client.client;

import com.anf.oauth.client.AbstractClient;
import com.anf.oauth.client.params.OauthParams;
import com.anf.oauth.json.BasicResponse;
import com.anf.oauth.json.JSONFactory;
import com.anf.ws.credential.client.exception.ExceptionNullParamsMessage;
import com.anf.ws.credential.client.interfaces.IClient;
import com.anf.ws.credential.client.model.AccessAuditObject;
import com.anf.ws.credential.client.model.CertificateInfo;
import com.anf.ws.credential.client.model.CheckCode2FARequest;
import com.anf.ws.credential.client.model.CredentialResponse;
import com.anf.ws.credential.client.model.OtpRequest;
import com.anf.ws.credential.client.model.Send2FARequest;
import com.anf.ws.credential.json.model.Response;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Base64;
import java.util.Date;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Client
extends AbstractClient
implements IClient {
    private static final Logger log = LogManager.getLogger(Client.class);

    public Client(String url, long timeout, OauthParams oauthParams) {
        super(url, 30000L, oauthParams);
    }

    public Client(String url, long timeout) {
        super(url, 30000L);
    }

    @Override
    public CredentialResponse checkCredentialAuthorization(AccessAuditObject accessAuditObject, CertificateInfo certificateInfo, String oid, String mac, Date dateRequestPermission) {
        CredentialResponse credentialResponse = new CredentialResponse();
        if (accessAuditObject == null || oid == null || mac == null || certificateInfo == null || dateRequestPermission == null) {
            log.error((Object)new ExceptionNullParamsMessage());
        } else {
            try {
                String uri = this.buildURIWithParams(accessAuditObject, certificateInfo, oid, mac);
                credentialResponse = this.handleRequest(new Send2FARequest(certificateInfo.getSerialCert()), uri);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return credentialResponse;
    }

    @Override
    public CredentialResponse sendCodeSms(String serialcertificatenumber) {
        return this.handleRequest(new Send2FARequest(serialcertificatenumber), "/credential/dobleauth/");
    }

    @Override
    public CredentialResponse checkCode(int code, String serialcertificatenumber) {
        return this.handleRequest(new CheckCode2FARequest(serialcertificatenumber, code), "/credential/checkcode/");
    }

    private <R> CredentialResponse handleRequest(R request, String endpoint) {
        CredentialResponse response = new CredentialResponse();
        try {
            Response resp = (Response)this.handleRequest(endpoint, request, Response.class, content -> new String((byte[])content).trim(), "POST", null);
            response.setResult(resp);
            response.setSucceded();
        }
        catch (IOException e) {
            log.error((Object)e);
            response.setFailed();
        }
        return response;
    }

    String buildURIWithParams(AccessAuditObject accessAuditObject, CertificateInfo certificateInfo, String oid, String mac) throws ParseException {
        URIBuilder uri = new URIBuilder();
        uri.setPath("/credential/check-authorization/");
        String appName = accessAuditObject.getAppName();
        String appVersion = accessAuditObject.getAppVersion();
        String url = accessAuditObject.getUrl();
        String ipAddress = accessAuditObject.getIpAddress();
        String serialCert = certificateInfo.getSerialCert();
        String dateIssue = this.normalizeDate(certificateInfo.getDateIssue());
        String dateExpiry = this.normalizeDate(certificateInfo.getDateExpiry());
        String dateRequestPermission = this.normalizeDate(accessAuditObject.getDateRequestPermission());
        String fullName = certificateInfo.getFullName();
        String username = certificateInfo.getUsername();
        String email = certificateInfo.getEmail();
        String typeCertificate = certificateInfo.getTypeCertificate().toString();
        this.addParameter(uri, "app-name", appName);
        this.addParameter(uri, "app-version", appVersion);
        this.addParameter(uri, "serial-cert", serialCert);
        this.addParameter(uri, "url", url);
        this.addParameter(uri, "date_issue", dateIssue);
        this.addParameter(uri, "date_issue", dateIssue);
        this.addParameter(uri, "date_expiry", dateExpiry);
        this.addParameter(uri, "full_name", fullName);
        this.addParameter(uri, "username", username);
        this.addParameter(uri, "email", email);
        this.addParameter(uri, "type_certificate", typeCertificate);
        this.addParameter(uri, "ip-address", ipAddress);
        this.addParameter(uri, "oid", oid);
        this.addParameter(uri, "date_request_permission", dateRequestPermission);
        this.addParameter(uri, "mac", mac);
        return uri.toString();
    }

    private void addParameter(URIBuilder uri, String name, String value) {
        value = value != null ? this.encodeB64(value) : "";
        uri.addParameter(name, value);
    }

    @Override
    public CredentialResponse registerCredential(X509Certificate cert) throws CertificateEncodingException, IOException {
        byte[] resp = this.handleRawRequest("/credential/register", "POST", "application/x-x509-user-cert", cert.getEncoded());
        return (CredentialResponse)JSONFactory.buildObject((byte[])resp, CredentialResponse.class);
    }

    @Override
    public BasicResponse useOtp(X509Certificate cert, String otp) throws IOException {
        log.info("credential {} using otp {}", (Object)cert.getSerialNumber(), (Object)otp);
        OtpRequest request = new OtpRequest();
        request.setOtp(otp);
        request.setSerial(cert.getSerialNumber().toString());
        byte[] resp = this.handleRawRequest("/credential/otp/use", "POST", "application/json", JSONFactory.buildJSON((Object)request).getBytes());
        log.info("credential {} otp response: {}", (Object)cert.getSerialNumber(), (Object)new String(resp));
        return (BasicResponse)JSONFactory.buildObject((byte[])resp, BasicResponse.class);
    }

    private String encodeB64(String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    public static void main(String[] args) {
    }
}

