/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf.visible;

import com.lowagie.text.Font;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.RGBColor;
import eu.europa.esig.dss.enumerations.VisualSignatureRotation;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.DSSFileFont;
import eu.europa.esig.dss.pades.DSSFont;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.SignatureImageTextParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.encryption.DSSSecureRandomProvider;
import eu.europa.esig.dss.pdf.openpdf.visible.AbstractITextSignatureDrawer;
import eu.europa.esig.dss.pdf.openpdf.visible.ITextDSSFontMetrics;
import eu.europa.esig.dss.pdf.openpdf.visible.ITextNativeFont;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;

public class TextOnlySignatureDrawer
extends AbstractITextSignatureDrawer {
    private Font iTextFont;

    @Override
    public void init(SignatureImageParameters parameters, PdfReader reader, PdfSignatureAppearance appearance) {
        super.init(parameters, reader, appearance);
        this.iTextFont = this.initFont();
    }

    public void draw() {
        this.appearance.setRender(0);
        SignatureFieldDimensionAndPosition dimensionAndPosition = this.buildSignatureFieldBox();
        String signatureFieldId = this.parameters.getFieldParameters().getFieldId();
        if (Utils.isStringNotBlank((String)signatureFieldId)) {
            this.appearance.setVisibleSignature(signatureFieldId);
        } else {
            AnnotationBox annotationBox = this.toAnnotationBox(dimensionAndPosition);
            annotationBox = this.getRotatedAnnotationRelativelyPageRotation(annotationBox);
            this.appearance.setVisibleSignature(this.toITextRectangle(annotationBox), this.parameters.getFieldParameters().getPage());
        }
        this.drawText(dimensionAndPosition);
    }

    private Font initFont() {
        SignatureImageTextParameters textParameters = this.parameters.getTextParameters();
        DSSFont dssFont = textParameters.getFont();
        BaseFont baseFont = this.getBaseFont(dssFont);
        Font font = new Font(baseFont, dssFont.getSize());
        font.setColor((Color)this.toExtendedColor(textParameters.getTextColor()));
        return font;
    }

    private BaseFont getBaseFont(DSSFont dssFont) {
        if (dssFont instanceof ITextNativeFont) {
            ITextNativeFont nativeFont = (ITextNativeFont)dssFont;
            return nativeFont.getFont();
        }
        if (dssFont instanceof DSSFileFont) {
            BaseFont baseFont;
            block10: {
                DSSFileFont fileFont = (DSSFileFont)dssFont;
                InputStream iStream = fileFont.getInputStream();
                try {
                    byte[] fontBytes = DSSUtils.toByteArray((InputStream)iStream);
                    BaseFont baseFont2 = BaseFont.createFont((String)fileFont.getName(), (String)"Identity-H", (boolean)true, (boolean)true, (byte[])fontBytes, null);
                    baseFont2.setSubset(fileFont.isEmbedFontSubset());
                    SecureRandom secureRandom = new DSSSecureRandomProvider(this.parameters).getSecureRandom();
                    baseFont2.setSecureRandom(secureRandom);
                    baseFont = baseFont2;
                    if (iStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (iStream != null) {
                            try {
                                iStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DSSException("The iText font cannot be initialized", (Throwable)e);
                    }
                }
                iStream.close();
            }
            return baseFont;
        }
        DefaultFontMapper fontMapper = new DefaultFontMapper();
        return fontMapper.awtToPdf(dssFont.getJavaFont());
    }

    protected ITextDSSFontMetrics getDSSFontMetrics() {
        return new ITextDSSFontMetrics(this.iTextFont.getBaseFont());
    }

    @Override
    protected PdfName getExpectedColorSpaceName() {
        return ImageUtils.containRGBColor((SignatureImageParameters)this.parameters) ? PdfName.DEVICERGB : PdfName.DEVICEGRAY;
    }

    private void drawText(SignatureFieldDimensionAndPosition dimensionAndPosition) {
        ITextDSSFontMetrics iTextFontMetrics = this.getDSSFontMetrics();
        SignatureImageTextParameters textParameters = this.parameters.getTextParameters();
        String text = dimensionAndPosition.getText();
        float size = dimensionAndPosition.getTextSize();
        PdfTemplate layer = this.appearance.getLayer(2);
        layer.setFontAndSize(this.iTextFont.getBaseFont(), size);
        Rectangle textRectangle = this.getTextBoxRectangle(dimensionAndPosition);
        textRectangle.setBackgroundColor((Color)this.toExtendedColor(textParameters.getBackgroundColor()));
        layer.rectangle(textRectangle);
        if (textParameters.getTextColor() != null) {
            layer.setColorFill((Color)this.toExtendedColor(textParameters.getTextColor()));
        }
        String[] lines = iTextFontMetrics.getLines(text);
        layer.beginText();
        this.rotateText(layer, dimensionAndPosition.getBoxWidth(), dimensionAndPosition.getBoxHeight(), dimensionAndPosition.getGlobalRotation());
        float x = dimensionAndPosition.getTextX();
        float y = dimensionAndPosition.getTextY() + dimensionAndPosition.getTextHeight() - iTextFontMetrics.getDescentPoint(lines[0], size);
        layer.moveText(x, y);
        layer.newlineText();
        float strHeight = iTextFontMetrics.getHeight(lines[0], size);
        y = -strHeight;
        float previousOffset = 0.0f;
        for (String line : lines) {
            float offsetX = 0.0f;
            float lineWidth = iTextFontMetrics.getWidth(line, size);
            switch (textParameters.getSignerTextHorizontalAlignment()) {
                case RIGHT: {
                    offsetX = dimensionAndPosition.getTextBoxWidth() - lineWidth - textParameters.getPadding() * 2.0f - previousOffset;
                    break;
                }
                case CENTER: {
                    offsetX = (dimensionAndPosition.getTextBoxWidth() - lineWidth) / 2.0f - textParameters.getPadding() - previousOffset;
                    break;
                }
            }
            previousOffset += offsetX;
            layer.moveText(offsetX, y);
            layer.newlineShowText(line);
        }
        layer.endText();
    }

    private ExtendedColor toExtendedColor(Color color) {
        if (color == null) {
            return null;
        }
        if (ImageUtils.isGrayscale((Color)color)) {
            return new GrayColor(color.getRed());
        }
        return new RGBColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private Rectangle getTextBoxRectangle(SignatureFieldDimensionAndPosition dimensionAndPosition) {
        AnnotationBox signatureFieldAnnotationBox = this.toAnnotationBox(dimensionAndPosition);
        VisualSignatureRotation rotation = this.parameters.getFieldParameters().getRotation();
        if (ImageRotationUtils.isSwapOfDimensionsRequired((VisualSignatureRotation)rotation)) {
            signatureFieldAnnotationBox = ImageRotationUtils.swapDimensions((AnnotationBox)signatureFieldAnnotationBox);
        }
        AnnotationBox textBox = new AnnotationBox(dimensionAndPosition.getTextBoxX(), dimensionAndPosition.getTextBoxY(), dimensionAndPosition.getTextBoxWidth() + dimensionAndPosition.getTextBoxX(), dimensionAndPosition.getTextBoxHeight() + dimensionAndPosition.getTextBoxY());
        int finalRotation = this.getFinalRotation(dimensionAndPosition.getGlobalRotation(), this.getPageRotation());
        textBox = ImageRotationUtils.rotateRelativelyWrappingBox((AnnotationBox)textBox, (AnnotationBox)signatureFieldAnnotationBox, (int)finalRotation);
        return this.toITextRectangle(textBox);
    }

    private void rotateText(PdfTemplate layer, float width, float height, int globalRotation) {
        int pageRotation = this.getPageRotation();
        if (ImageRotationUtils.isSwapOfDimensionsRequired((int)pageRotation)) {
            float temp = height;
            height = width;
            width = temp;
        }
        int finalRotation = this.getFinalRotation(globalRotation, pageRotation);
        double theta = Math.toRadians(360.0 - (double)finalRotation);
        float cosTheta = (float)Math.cos(theta);
        float sinTheta = (float)Math.sin(theta);
        switch (finalRotation) {
            case 90: {
                layer.setTextMatrix(cosTheta, sinTheta, -sinTheta, cosTheta, 0.0f, height);
                break;
            }
            case 180: {
                layer.setTextMatrix(cosTheta, sinTheta, -sinTheta, cosTheta, width, height);
                break;
            }
            case 270: {
                layer.setTextMatrix(cosTheta, sinTheta, -sinTheta, cosTheta, width, 0.0f);
                break;
            }
            case 0: 
            case 360: {
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
    }
}

