/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf.visible;

import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfTemplate;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.openpdf.visible.AbstractITextSignatureDrawer;
import eu.europa.esig.dss.pdf.visible.DSSFontMetrics;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.visible.SignatureFieldDimensionAndPosition;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;

public class ImageOnlySignatureDrawer
extends AbstractITextSignatureDrawer {
    private Image image;

    public void draw() {
        Image currentImage = this.getImage();
        SignatureFieldParameters fieldParameters = this.parameters.getFieldParameters();
        String signatureFieldId = fieldParameters.getFieldId();
        SignatureFieldDimensionAndPosition dimensionAndPosition = this.buildSignatureFieldBox();
        if (Utils.isStringNotBlank((String)signatureFieldId)) {
            this.appearance.setVisibleSignature(signatureFieldId);
        } else {
            AnnotationBox annotationBox = this.toAnnotationBox(dimensionAndPosition);
            annotationBox = this.getRotatedAnnotationRelativelyPageRotation(annotationBox);
            this.appearance.setVisibleSignature(this.toITextRectangle(annotationBox), fieldParameters.getPage());
        }
        float x = dimensionAndPosition.getImageX();
        float y = dimensionAndPosition.getImageY();
        float width = dimensionAndPosition.getImageWidth();
        float height = dimensionAndPosition.getImageHeight();
        int finalRotation = this.getFinalRotation(dimensionAndPosition.getGlobalRotation(), this.getPageRotation());
        if (ImageRotationUtils.isSwapOfDimensionsRequired((int)finalRotation)) {
            x = dimensionAndPosition.getImageY();
            y = dimensionAndPosition.getImageX();
        }
        currentImage.setAbsolutePosition(x, y);
        currentImage.scaleAbsolute(width, height);
        currentImage.setRotationDegrees(360.0f - (float)finalRotation);
        PdfTemplate layer = this.appearance.getLayer(2);
        Rectangle boundingBox = layer.getBoundingBox();
        boundingBox.setBackgroundColor(this.parameters.getBackgroundColor());
        layer.rectangle(boundingBox);
        layer.addImage(currentImage);
    }

    private Image getImage() {
        if (this.image == null) {
            try {
                this.image = Image.getInstance((byte[])DSSUtils.toByteArray((DSSDocument)this.parameters.getImage()));
            }
            catch (IOException e) {
                throw new IllegalInputException(String.format("Unable to read the provided image file. Reason : %s", e.getMessage()), (Throwable)e);
            }
        }
        return this.image;
    }

    @Override
    protected DSSFontMetrics getDSSFontMetrics() {
        return null;
    }

    @Override
    protected PdfName getExpectedColorSpaceName() {
        switch (this.getImage().getColorspace()) {
            case 1: {
                return PdfName.DEVICEGRAY;
            }
            case 3: {
                return PdfName.DEVICERGB;
            }
        }
        return PdfName.DEVICECMYK;
    }
}

