/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSimpleObject;
import eu.europa.esig.dss.pdf.openpdf.ITextObjectKey;
import eu.europa.esig.dss.pdf.openpdf.ITextPdfDict;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ITextPdfArray
implements PdfArray {
    private static final Logger LOG = LoggerFactory.getLogger(ITextPdfArray.class);
    private final com.lowagie.text.pdf.PdfArray wrapped;
    private final PdfObject parent;

    public ITextPdfArray() {
        this(new com.lowagie.text.pdf.PdfArray(), null);
    }

    public ITextPdfArray(com.lowagie.text.pdf.PdfArray wrapped) {
        this(wrapped, null);
    }

    public ITextPdfArray(com.lowagie.text.pdf.PdfArray wrapped, PdfObject parent) {
        Objects.requireNonNull(wrapped, "Pdf array shall be provided!");
        this.wrapped = wrapped;
        this.parent = parent;
    }

    public com.lowagie.text.pdf.PdfArray getValue() {
        return this.wrapped;
    }

    public PdfObject getParent() {
        return this.parent;
    }

    public byte[] getStreamBytes(int i) throws IOException {
        return PdfReader.getStreamBytes((PRStream)((PRStream)this.wrapped.getAsStream(i)));
    }

    @Deprecated
    public Long getObjectNumber(int i) {
        ITextObjectKey objectKey = this.getObjectKey(i);
        if (objectKey != null) {
            return objectKey.getValue().getNumber();
        }
        return null;
    }

    public ITextObjectKey getObjectKey(int i) {
        com.lowagie.text.pdf.PdfObject pdfObject = this.wrapped.getPdfObject(i);
        if (pdfObject == null) {
            throw new DSSException("The requested PDF object not found!");
        }
        if (pdfObject.isStream()) {
            PdfStream asStream = this.wrapped.getAsStream(i);
            return new ITextObjectKey((PdfIndirectReference)asStream.getIndRef());
        }
        if (pdfObject.isIndirect()) {
            PdfIndirectReference asIndirectObject = this.wrapped.getAsIndirectObject(i);
            return new ITextObjectKey(asIndirectObject);
        }
        return null;
    }

    public Number getNumber(int i) {
        PdfNumber number = this.wrapped.getAsNumber(i);
        if (number != null) {
            if (this.isInteger(number)) {
                return number.intValue();
            }
            return number.doubleValue();
        }
        return null;
    }

    private boolean isInteger(PdfNumber number) {
        return Utils.isStringDigits((String)new String(number.getBytes()));
    }

    public String getString(int i) {
        PdfString pdfString = this.wrapped.getAsString(i);
        if (pdfString != null) {
            return pdfString.toString();
        }
        return null;
    }

    public PdfDict getAsDict(int i) {
        com.lowagie.text.pdf.PdfObject directObject = this.wrapped.getDirectObject(i);
        if (directObject instanceof PdfDictionary) {
            return new ITextPdfDict((PdfDictionary)directObject, (PdfObject)this);
        }
        return null;
    }

    public PdfObject getObject(int i) {
        com.lowagie.text.pdf.PdfObject directObject = this.wrapped.getDirectObject(i);
        if (directObject == null) {
            return null;
        }
        if (directObject instanceof PdfDictionary) {
            return this.getAsDict(i);
        }
        if (directObject instanceof com.lowagie.text.pdf.PdfArray) {
            return new ITextPdfArray((com.lowagie.text.pdf.PdfArray)directObject, (PdfObject)this);
        }
        if (directObject instanceof PdfString) {
            return new PdfSimpleObject((Object)this.getString(i), (PdfObject)this);
        }
        if (directObject instanceof PdfName) {
            return new PdfSimpleObject((Object)PdfName.decodeName((String)directObject.toString()), (PdfObject)this);
        }
        if (directObject instanceof PdfNumber) {
            return new PdfSimpleObject((Object)this.getNumber(i), (PdfObject)this);
        }
        if (directObject instanceof PdfBoolean) {
            return new PdfSimpleObject((Object)((PdfBoolean)directObject).booleanValue(), (PdfObject)this);
        }
        if (directObject instanceof PdfNull) {
            return null;
        }
        LOG.warn("Unable to process an entry on position '{}' of type '{}'.", (Object)i, directObject.getClass());
        return null;
    }

    public void addObject(PdfObject pdfObject) {
        Object value = pdfObject.getValue();
        if (!(value instanceof com.lowagie.text.pdf.PdfObject)) {
            throw new UnsupportedOperationException("The object to be added shall be of type PdfObject!");
        }
        this.wrapped.add((com.lowagie.text.pdf.PdfObject)value);
    }

    public void setDirect(boolean direct) {
    }

    public int size() {
        return this.wrapped.size();
    }
}

