/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.openpdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.exception.InvalidPasswordException;
import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.PdfSigDictWrapper;
import eu.europa.esig.dss.pdf.SingleDssDict;
import eu.europa.esig.dss.pdf.openpdf.ITextObjectKey;
import eu.europa.esig.dss.pdf.openpdf.ITextPdfArray;
import eu.europa.esig.dss.pdf.openpdf.ITextPdfDict;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITextDocumentReader
implements PdfDocumentReader {
    private static final Logger LOG = LoggerFactory.getLogger(ITextDocumentReader.class);
    private final PdfReader pdfReader;
    private DSSDocument dssDocument;
    private Map<PdfSignatureDictionary, List<PdfSignatureField>> signatureDictionaryMap;

    public ITextDocumentReader(DSSDocument dssDocument) throws IOException, InvalidPasswordException {
        this(dssDocument, null);
    }

    public ITextDocumentReader(DSSDocument dssDocument, byte[] passwordProtection) throws IOException, InvalidPasswordException {
        this(dssDocument, passwordProtection, PAdESUtils.DEFAULT_PDF_MEMORY_USAGE_SETTING);
    }

    public ITextDocumentReader(DSSDocument dssDocument, byte[] passwordProtection, PdfMemoryUsageSetting pdfMemoryUsageSetting) throws IOException, InvalidPasswordException {
        block10: {
            Objects.requireNonNull(dssDocument, "The document must be defined!");
            Objects.requireNonNull(pdfMemoryUsageSetting, "PdfMemoryUsageSetting must be defined!");
            this.dssDocument = dssDocument;
            try {
                if (PdfMemoryUsageSetting.Mode.MEMORY_FULL != pdfMemoryUsageSetting.getMode() && dssDocument instanceof FileDocument) {
                    FileDocument fileDocument = (FileDocument)dssDocument;
                    this.pdfReader = this.getFileDocumentPdfReader(fileDocument, passwordProtection, pdfMemoryUsageSetting);
                    break block10;
                }
                if (dssDocument instanceof InMemoryDocument) {
                    InMemoryDocument inMemoryDocument = (InMemoryDocument)dssDocument;
                    this.pdfReader = new PdfReader(inMemoryDocument.getBytes(), passwordProtection);
                    break block10;
                }
                try (InputStream is = dssDocument.openStream();){
                    this.pdfReader = new PdfReader(is, passwordProtection);
                }
            }
            catch (BadPasswordException e) {
                throw new InvalidPasswordException(String.format("Encrypted document : %s", e.getMessage()));
            }
        }
    }

    private PdfReader getFileDocumentPdfReader(FileDocument fileDocument, byte[] passwordProtection, PdfMemoryUsageSetting pdfMemoryUsageSetting) throws IOException {
        String filenameSource = fileDocument.getFile().getAbsolutePath();
        switch (pdfMemoryUsageSetting.getMode()) {
            case MEMORY_BUFFERED: {
                return new PdfReader(filenameSource, passwordProtection);
            }
            case FILE: {
                return new PdfReader(new RandomAccessFileOrArray(filenameSource, false, true), passwordProtection);
            }
        }
        throw new IllegalArgumentException(String.format("The PdfMemoryUsageSetting mode '%s' is not supported in dss-pades-openpdf implementation!", pdfMemoryUsageSetting.getMode()));
    }

    public ITextDocumentReader(byte[] binaries, byte[] passwordProtection) throws IOException, InvalidPasswordException {
        Objects.requireNonNull(binaries, "The document binaries must be defined!");
        this.dssDocument = new InMemoryDocument(binaries);
        try {
            this.pdfReader = new PdfReader(binaries, passwordProtection);
        }
        catch (BadPasswordException e) {
            throw new InvalidPasswordException(String.format("Encrypted document : %s", e.getMessage()));
        }
    }

    public ITextDocumentReader(PdfReader pdfReader) {
        this.pdfReader = pdfReader;
    }

    public PdfReader getPdfReader() {
        return this.pdfReader;
    }

    public PdfDssDict getDSSDictionary() {
        PdfDict currentCatalog = this.getCatalogDictionary();
        return SingleDssDict.extract((PdfDict)currentCatalog);
    }

    public Map<PdfSignatureDictionary, List<PdfSignatureField>> extractSigDictionaries() {
        if (this.signatureDictionaryMap == null) {
            this.signatureDictionaryMap = new LinkedHashMap<PdfSignatureDictionary, List<PdfSignatureField>>();
            LinkedHashMap<Integer, PdfSigDictWrapper> pdfObjectDictMap = new LinkedHashMap<Integer, PdfSigDictWrapper>();
            AcroFields acroFields = this.pdfReader.getAcroFields();
            Map allFields = acroFields.getAllFields();
            List names = acroFields.getSignedFieldNames();
            LOG.debug("{} signature field(s) found", (Object)names.size());
            for (String name : names) {
                List<PdfSignatureField> fieldList;
                PdfSigDictWrapper signature;
                PdfDictionary pdfField = ((AcroFields.Item)allFields.get(name)).getMerged(0);
                ITextPdfDict fieldDict = new ITextPdfDict(pdfField);
                PdfSignatureField pdfSignatureField = new PdfSignatureField((PdfDict)fieldDict);
                int refNumber = 0;
                PdfIndirectReference indirectObject = pdfField.getAsIndirectObject(PdfName.V);
                if (indirectObject != null) {
                    refNumber = indirectObject.getNumber();
                }
                if ((signature = (PdfSigDictWrapper)pdfObjectDictMap.get(refNumber)) == null) {
                    try {
                        ITextPdfDict dictionary = new ITextPdfDict(pdfField.getAsDict(PdfName.V));
                        signature = new PdfSigDictWrapper((PdfDict)dictionary);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to create a PdfSignatureDictionary for field with name '{}'", (Object)name, (Object)e);
                        continue;
                    }
                    fieldList = new ArrayList<PdfSignatureField>();
                    fieldList.add(pdfSignatureField);
                    this.signatureDictionaryMap.put((PdfSignatureDictionary)signature, fieldList);
                    pdfObjectDictMap.put(refNumber, signature);
                    continue;
                }
                fieldList = this.signatureDictionaryMap.get(signature);
                fieldList.add(pdfSignatureField);
                LOG.warn("More than one field refers to the same signature dictionary: {}!", fieldList);
            }
        }
        return this.signatureDictionaryMap;
    }

    public void close() {
        this.pdfReader.close();
    }

    public boolean isSignatureCoversWholeDocument(PdfSignatureDictionary signatureDictionary) {
        AcroFields acroFields = this.pdfReader.getAcroFields();
        List<PdfSignatureField> fields = this.signatureDictionaryMap.get(signatureDictionary);
        if (Utils.isCollectionNotEmpty(fields)) {
            return acroFields.signatureCoversWholeDocument(fields.get(0).getFieldName());
        }
        throw new DSSException("Not applicable use of the method isSignatureCoversWholeDocument. The requested signatureDictionary does not exist!");
    }

    public int getNumberOfPages() {
        return this.pdfReader.getNumberOfPages();
    }

    public AnnotationBox getPageBox(int page) {
        Rectangle pageRectangle = this.pdfReader.getPageSize(page);
        return new AnnotationBox(pageRectangle.getLeft(), pageRectangle.getBottom(), pageRectangle.getRight(), pageRectangle.getTop());
    }

    public int getPageRotation(int page) {
        return this.pdfReader.getPageRotation(page);
    }

    public List<PdfAnnotation> getPdfAnnotations(int page) {
        PdfDictionary pageDictionary = this.pdfReader.getPageN(page);
        com.lowagie.text.pdf.PdfArray annots = pageDictionary.getAsArray(PdfName.ANNOTS);
        if (annots != null) {
            ArrayList<PdfAnnotation> pdfAnnotations = new ArrayList<PdfAnnotation>();
            int pageRotation = this.getPageRotation(page);
            for (PdfObject pdfObject : annots.getElements()) {
                PdfAnnotation pdfAnnotation = this.toPdfAnnotation(pdfObject, pageRotation);
                if (pdfAnnotation == null) continue;
                pdfAnnotations.add(pdfAnnotation);
            }
            return pdfAnnotations;
        }
        return Collections.emptyList();
    }

    private PdfAnnotation toPdfAnnotation(PdfObject pdfObject, int pageRotation) {
        AnnotationBox annotationBox;
        PdfDictionary annotDictionary = this.getAnnotDictionary(pdfObject);
        if (annotDictionary != null && (annotationBox = this.getAnnotationBox(annotDictionary)) != null) {
            if (this.isNoRotate(annotDictionary)) {
                annotationBox = ImageRotationUtils.ensureNoRotate((AnnotationBox)annotationBox, (int)pageRotation);
            }
            PdfAnnotation pdfAnnotation = new PdfAnnotation(annotationBox);
            pdfAnnotation.setName(this.getSignatureFieldName(annotDictionary));
            pdfAnnotation.setSigned(this.isSignedField(annotDictionary));
            return pdfAnnotation;
        }
        return null;
    }

    private boolean isNoRotate(PdfDictionary annotDictionary) {
        PdfNumber pdfNumber = annotDictionary.getAsNumber(PdfName.F);
        if (pdfNumber != null) {
            int ff = pdfNumber.intValue();
            return (ff & 0x10) == 16;
        }
        return false;
    }

    private PdfDictionary getAnnotDictionary(PdfObject pdfObject) {
        if (pdfObject.isIndirect()) {
            pdfObject = PdfReader.getPdfObject((PdfObject)pdfObject);
        }
        if (pdfObject.isDictionary()) {
            return (PdfDictionary)pdfObject;
        }
        return null;
    }

    private AnnotationBox getAnnotationBox(PdfDictionary annotDictionary) {
        com.lowagie.text.pdf.PdfArray annotRect = annotDictionary.getAsArray(PdfName.RECT);
        if (annotRect.size() == 4) {
            PdfNumber pdfNumber0 = annotRect.getAsNumber(0);
            PdfNumber pdfNumber1 = annotRect.getAsNumber(1);
            PdfNumber pdfNumber2 = annotRect.getAsNumber(2);
            PdfNumber pdfNumber3 = annotRect.getAsNumber(3);
            if (pdfNumber0 != null && pdfNumber1 != null && pdfNumber2 != null && pdfNumber3 != null) {
                return new AnnotationBox((float)pdfNumber0.intValue(), (float)pdfNumber1.intValue(), (float)pdfNumber2.intValue(), (float)pdfNumber3.intValue());
            }
            LOG.debug("Wrong type of an array entry found in RECT dictionary. Skip the annotation.");
        } else {
            LOG.debug("Annotation RECT contains wrong amount of elements. 4 entries is expected.");
        }
        return null;
    }

    private String getSignatureFieldName(PdfDictionary annotDictionary) {
        PdfString pdfString = annotDictionary.getAsString(PdfName.T);
        if (pdfString != null) {
            return pdfString.toString();
        }
        return null;
    }

    private boolean isSignedField(PdfDictionary annotDictionary) {
        return annotDictionary.getAsDict(PdfName.V) != null;
    }

    public PdfObject getObjectByKey(PdfObjectKey objectKey) {
        if (objectKey instanceof ITextObjectKey) {
            ITextObjectKey iTextObjectKey = (ITextObjectKey)objectKey;
            return this.pdfReader.getPdfObject(iTextObjectKey.getValue().getNumber());
        }
        throw new IllegalStateException("objectKey shall be of type 'ITextObjectKey'!");
    }

    public PdfStream createPdfStream(byte[] binaries) {
        return new PdfStream(binaries);
    }

    public BufferedImage generateImageScreenshot(int page) {
        throw new UnsupportedOperationException("The image generation is not supported with OpenPDF implementation!");
    }

    public BufferedImage generateImageScreenshotWithoutAnnotations(int page, List<PdfAnnotation> annotations) {
        throw new UnsupportedOperationException("The image generation is not supported with OpenPDF implementation!");
    }

    public boolean isEncrypted() {
        return this.pdfReader.isEncrypted();
    }

    public boolean isOpenWithOwnerAccess() {
        return !this.isEncrypted() || this.pdfReader.isOwnerPasswordUsed();
    }

    public boolean canFillSignatureForm() {
        if (!this.isOpenWithOwnerAccess()) {
            int permissions = this.pdfReader.getPermissions();
            return this.isAllowModifyAnnotations(permissions) || this.isAllowFillIn(permissions);
        }
        return true;
    }

    public boolean canCreateSignatureField() {
        if (!this.isOpenWithOwnerAccess()) {
            int permissions = this.pdfReader.getPermissions();
            return this.isAllowModifyContents(permissions) && this.isAllowModifyAnnotations(permissions);
        }
        return true;
    }

    private boolean isAllowModifyContents(int permissions) {
        return this.isPermissionBitPresent(permissions, 8);
    }

    private boolean isAllowModifyAnnotations(int permissions) {
        return this.isPermissionBitPresent(permissions, 32);
    }

    private boolean isAllowFillIn(int permissions) {
        return this.isPermissionBitPresent(permissions, 256);
    }

    private boolean isPermissionBitPresent(int permissions, int permissionBit) {
        return (permissionBit & permissions) > 0;
    }

    public CertificationPermission getCertificationPermission() {
        int certificationLevel = this.pdfReader.getCertificationLevel();
        if (certificationLevel > 0) {
            return CertificationPermission.fromCode((int)certificationLevel);
        }
        return null;
    }

    public boolean isUsageRightsSignaturePresent() {
        PdfDictionary permsDict;
        PdfDictionary catalog = this.pdfReader.getCatalog();
        if (catalog != null && (permsDict = catalog.getAsDict(PdfName.PERMS)) != null) {
            PdfObject object = permsDict.get(PdfName.UR);
            if (object != null) {
                return true;
            }
            object = permsDict.get(PdfName.UR3);
            if (object != null) {
                return true;
            }
        }
        return false;
    }

    public PdfDict getCatalogDictionary() {
        return new ITextPdfDict(this.pdfReader.getCatalog());
    }

    public PdfObject generateDocumentId(PAdESCommonParameters parameters) {
        PdfLiteral pdfLiteral;
        String deterministicId = parameters.getDeterministicId();
        if (this.dssDocument != null) {
            if (this.dssDocument.getName() != null) {
                deterministicId = deterministicId + "-" + this.dssDocument.getName();
            }
            deterministicId = deterministicId + "-" + DSSUtils.getFileByteSize((DSSDocument)this.dssDocument);
        }
        String md5 = DSSUtils.getMD5Digest((byte[])deterministicId.getBytes());
        byte[] bytes = Utils.fromHex((String)md5);
        ByteBuffer buf = new ByteBuffer(90);
        try {
            int k;
            buf.append('[').append('<');
            for (k = 0; k < 16; ++k) {
                buf.appendHex(bytes[k]);
            }
            buf.append('>').append('<');
            for (k = 0; k < 16; ++k) {
                buf.appendHex(bytes[k]);
            }
            buf.append('>').append(']');
            pdfLiteral = new PdfLiteral(buf.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    buf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException("Unable to generate the fileId", (Throwable)e);
            }
        }
        buf.close();
        return pdfLiteral;
    }

    public float getPdfHeaderVersion() {
        char pdfVersionLastChar = this.pdfReader.getPdfVersion();
        float numVersion = 1.0f + (float)Character.getNumericValue(pdfVersionLastChar) / 10.0f;
        if (numVersion == 1.0f) {
            numVersion += 1.0f;
        }
        return numVersion;
    }

    public float getVersion() {
        float version = this.getPdfHeaderVersion();
        PdfDictionary catalog = this.pdfReader.getCatalog();
        try {
            PdfName versionName;
            if (catalog != null && (versionName = catalog.getAsName(PdfName.VERSION)) != null) {
                version = Float.parseFloat(PdfName.decodeName((String)versionName.toString()));
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred on catalog /Version extraction : {}", (Object)e.getMessage(), (Object)e);
        }
        return version;
    }

    public void setVersion(float version) {
        this.pdfReader.getCatalog().put(PdfName.VERSION, (PdfObject)new PdfName(PdfName.encodeName((String)Float.toString(version))));
    }

    public PdfDict createPdfDict() {
        return new ITextPdfDict();
    }

    public PdfArray createPdfArray() {
        return new ITextPdfArray();
    }
}

