/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import com.anf.cryptotoken.sign.verifier.sources.tsl.model.CertIdentifier;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.security.PublicKey;
import java.util.Base64;
import javax.security.auth.x500.X500Principal;

public class GetCertificateBy {
    private String method;
    private String ski;
    private String digest;
    private String digestAlgorithm;
    private CertIdentifier identifier;
    private String publicKey;
    private String issuerName;

    public GetCertificateBy() {
    }

    public GetCertificateBy(SignerIdentifier id) {
        this.method = "identifier";
        this.identifier = new CertIdentifier(id);
    }

    public GetCertificateBy(Digest digest2) {
        this.method = "digest";
        this.digest = Base64.getEncoder().encodeToString(digest2.getValue());
        this.digestAlgorithm = digest2.getAlgorithm().getName();
    }

    public GetCertificateBy(PublicKey publicKey2) {
        this.method = "key";
        this.publicKey = Base64.getEncoder().encodeToString(publicKey2.getEncoded());
    }

    public GetCertificateBy(byte[] ski2) {
        this.method = "ski";
        this.ski = Base64.getEncoder().encodeToString(ski2);
    }

    public GetCertificateBy(X500Principal principal) {
        this.method = "issuerName";
        this.issuerName = Base64.getEncoder().encodeToString(principal.getEncoded());
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getSki() {
        return this.ski;
    }

    public void setSki(String ski) {
        this.ski = ski;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public CertIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(CertIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }
}

