/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl.model;

import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.math.BigInteger;
import java.util.Base64;
import javax.security.auth.x500.X500Principal;

public class CertIdentifier {
    private String issuerName;
    private String serialNumber;
    private String ski;

    public CertIdentifier(SignerIdentifier id) {
        if (id.getIssuerName() != null) {
            this.issuerName = Base64.getEncoder().encodeToString(id.getIssuerName().getEncoded());
        }
        if (id.getSerialNumber() != null) {
            this.serialNumber = id.getSerialNumber().toString();
        }
        if (id.getSki() != null) {
            this.ski = Base64.getEncoder().encodeToString(id.getSki());
        }
    }

    public SignerIdentifier toIdentifier() {
        SignerIdentifier id = new SignerIdentifier();
        if (this.issuerName != null) {
            X500Principal issuerName = new X500Principal(Base64.getDecoder().decode(this.issuerName.getBytes()));
            id.setIssuerName(issuerName);
        }
        if (this.serialNumber != null) {
            id.setSerialNumber(new BigInteger(this.serialNumber));
        }
        if (this.ski != null) {
            id.setSki(Base64.getDecoder().decode(this.ski.getBytes()));
        }
        return id;
    }
}

