/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.LOTLInfoJson;
import com.anf.cryptotoken.sign.verifier.sources.tsl.model.TLinfoJson;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class TLValidationSummaryService
extends TLValidationJobSummary {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TLValidationSummaryService.class);
    private HttpClient client;
    private RequestConfig config;
    private String url;

    public TLValidationSummaryService(String url, HttpClient client, RequestConfig config) {
        super(new ArrayList<LOTLInfo>(List.of(new LOTLInfo(null, null, null, ""))), new ArrayList<TLInfo>(List.of(new TLInfo(null, null, null, ""))));
        this.client = client;
        this.config = config;
        this.url = url;
        this.getOtherTLInfos().clear();
        this.getLOTLInfos().clear();
    }

    public synchronized void refresh() {
        this.getOtherTLInfos().clear();
    }

    public synchronized TLInfo getTLInfoById(Identifier identifier) {
        TLInfo tlinfo = super.getTLInfoById(identifier);
        if (tlinfo != null) {
            return tlinfo;
        }
        try {
            tlinfo = this.connect("/validate/tsl/info-id", identifier.asXmlId(), json -> {
                TLinfoJson info = TLinfoJson.fromJson(json);
                TLInfo tl = info.toObject();
                this.getOtherTLInfos().add(tl);
                log.info((Object)("tlinfo from service: " + tl.getDSSId().asXmlId()));
                return tl;
            });
        }
        catch (IOException | UnsupportedOperationException e) {
            log.warn((Object)("error tl info cert " + identifier.asXmlId() + " error: " + e.getMessage()));
        }
        return tlinfo;
    }

    public LOTLInfo getLOTLInfoById(Identifier identifier) {
        LOTLInfo info = super.getLOTLInfoById(identifier);
        if (info != null) {
            return info;
        }
        try {
            info = this.connect("/validate/tsl/lotl-info-id", identifier.asXmlId(), json -> {
                LOTLInfoJson lotl = LOTLInfoJson.fromJson(json);
                LOTLInfo tl = lotl.toObject();
                this.getLOTLInfos().add(tl);
                log.info((Object)("lotl info from service: " + tl.getDSSId().asXmlId()));
                return tl;
            });
        }
        catch (IOException | UnsupportedOperationException e) {
            log.warn((Object)("error tl info cert " + identifier.asXmlId() + " error: " + e.getMessage()));
        }
        return info;
    }

    private <R> R connect(String endpoint, String id, Function<String, R> result) throws IOException {
        HttpPost request = new HttpPost(this.url + endpoint);
        request.setEntity((HttpEntity)new StringEntity(id));
        request.setConfig(this.config);
        return (R)this.client.execute((ClassicHttpRequest)request, httpResp -> {
            int statusCode = httpResp.getCode();
            if (statusCode == 200) {
                String json = new String(IOUtils.toByteArray((InputStream)httpResp.getEntity().getContent()));
                return result.apply(json);
            }
            return null;
        });
    }
}

