/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources.tsl;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.log.Logger;
import eu.europa.esig.dss.alert.Alert;
import eu.europa.esig.dss.alert.detector.AlertDetector;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustPropertiesCertificateSource;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.service.http.commons.FileCacheDataLoader;
import eu.europa.esig.dss.spi.client.http.DSSCacheFileLoader;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.tsl.alerts.LOTLAlert;
import eu.europa.esig.dss.tsl.alerts.TLAlert;
import eu.europa.esig.dss.tsl.alerts.detections.LOTLLocationChangeDetection;
import eu.europa.esig.dss.tsl.alerts.detections.OJUrlChangeDetection;
import eu.europa.esig.dss.tsl.alerts.detections.TLExpirationDetection;
import eu.europa.esig.dss.tsl.alerts.detections.TLSignatureErrorDetection;
import eu.europa.esig.dss.tsl.cache.CacheCleaner;
import eu.europa.esig.dss.tsl.job.TLValidationJob;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.trustedlist.TrustedListFacade;
import eu.europa.esig.trustedlist.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.trustedlist.jaxb.tsl.MultiLangNormStringType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSLSchemeInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TrustStatusListType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.bouncycastle.util.encoders.Hex;

public class ANFTSLCachedCertificateSource
extends TrustedListsCertificateSource {
    private static final Logger log = Logger.getLogger(ANFTSLCachedCertificateSource.class);
    private static final long serialVersionUID = 1L;
    public static final String EU_URL = "https://ec.europa.eu/tools/lotl/eu-lotl.xml";
    private transient TLValidationJob validationJob;
    private BigInteger tslVersionIdentifier;
    private BigInteger tslSequenceNumber;
    private String tslType;
    private String id;
    private String name;
    private Calendar issueDate;
    private Calendar nextUpdate;
    private CommonsDataLoader commonsHttpDataLoader = new CommonsDataLoader();
    private File tmpCacheDir = new File(FileUtils.getTempDirectory(), "TSL-" + UUID.randomUUID().toString());

    public ANFTSLCachedCertificateSource() {
        this(EU_URL, null);
    }

    public ANFTSLCachedCertificateSource(String tslUrl, Predicate<String> tslFilter) {
        LOTLSource europeanLOTL = new LOTLSource();
        europeanLOTL.setUrl(tslUrl);
        europeanLOTL.setCertificateSource((CertificateSource)new CommonCertificateSource());
        europeanLOTL.setPivotSupport(true);
        if (tslFilter != null) {
            europeanLOTL.setTlPredicate(pointer -> tslFilter.test(pointer.getTSLLocation()));
        }
        TrustStrategy st = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        };
        this.commonsHttpDataLoader.setTrustStrategy(st);
        FileCacheDataLoader onlineFileLoader = new FileCacheDataLoader((DataLoader)this.commonsHttpDataLoader);
        onlineFileLoader.setCacheExpirationTime(0L);
        this.tmpCacheDir.mkdirs();
        onlineFileLoader.setFileCacheDirectory(this.tmpCacheDir);
        CacheCleaner cacheCleaner = new CacheCleaner();
        cacheCleaner.setCleanFileSystem(true);
        cacheCleaner.setCleanMemory(true);
        cacheCleaner.setDSSFileLoader((DSSCacheFileLoader)onlineFileLoader);
        this.validationJob = new TLValidationJob();
        this.validationJob.setTrustedListCertificateSource((TrustPropertiesCertificateSource)this);
        this.validationJob.setOnlineDataLoader((DSSFileLoader)onlineFileLoader);
        this.validationJob.setCacheCleaner(cacheCleaner);
        this.validationJob.setListOfTrustedListSources(new LOTLSource[]{europeanLOTL});
        this.validationJob.setLOTLAlerts(Arrays.asList(this.lotlLocationAlert(europeanLOTL), this.lotlUrlAlert(europeanLOTL)));
        this.validationJob.setTLAlerts(Arrays.asList(this.tlSigningAlert(), this.tlExpirationDetection()));
    }

    public File getTmpCacheDir() {
        return this.tmpCacheDir;
    }

    public Alert<TLInfo> tlSigningAlert() {
        TLSignatureErrorDetection signingDetection = new TLSignatureErrorDetection();
        return new TLAlert((AlertDetector)signingDetection, info -> log.error((Object)("error de firma de la TSL: " + info.getUrl())));
    }

    public Alert<TLInfo> tlExpirationDetection() {
        TLExpirationDetection expirationDetection = new TLExpirationDetection();
        return new TLAlert((AlertDetector)expirationDetection, info -> log.info((Object)("detectada expiracion de TSL " + info.getUrl())));
    }

    public Alert<LOTLInfo> lotlUrlAlert(LOTLSource source) {
        OJUrlChangeDetection ojUrlDetection = new OJUrlChangeDetection(source);
        return new LOTLAlert((AlertDetector)ojUrlDetection, info -> log.info(new Object[]{"The Official Journal URL has changed - new location : ", info.getParsingCacheInfo().getSigningCertificateAnnouncementUrl()}));
    }

    public Alert<LOTLInfo> lotlLocationAlert(LOTLSource source) {
        LOTLLocationChangeDetection lotlLocationDetection = new LOTLLocationChangeDetection(source);
        return new LOTLAlert((AlertDetector)lotlLocationDetection, info -> log.error((Object)("ha cambiado la URL de la TSL " + info.getUrl())));
    }

    public synchronized void update() {
        this.validationJob.onlineRefresh();
        byte[] content = this.commonsHttpDataLoader.get(EU_URL);
        try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
            TrustStatusListType jaxbContext = (TrustStatusListType)TrustedListFacade.newFacade().unmarshall((InputStream)is);
            TSLSchemeInformationType schemeInformation = jaxbContext.getSchemeInformation();
            this.id = jaxbContext.getId();
            this.tslSequenceNumber = schemeInformation.getTSLSequenceNumber();
            this.tslVersionIdentifier = schemeInformation.getTSLVersionIdentifier();
            this.tslType = schemeInformation.getTSLType();
            this.issueDate = schemeInformation.getListIssueDateTime().toGregorianCalendar();
            this.nextUpdate = schemeInformation.getNextUpdate().getDateTime().toGregorianCalendar();
            InternationalNamesType schemeName = schemeInformation.getSchemeOperatorName();
            if (!schemeName.getName().isEmpty()) {
                this.name = ((MultiLangNormStringType)schemeName.getName().get(0)).getValue();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public X509Certificate findIssuer(X509Certificate cert) {
        List certificates = this.getCertificates();
        for (CertificateToken certificateToken : certificates) {
            if (!CertUtils.isIssuer((X509Certificate)cert, (X509Certificate)certificateToken.getCertificate())) continue;
            return certificateToken.getCertificate();
        }
        return null;
    }

    public boolean isKnown(CertificateToken token) {
        boolean known = super.isKnown(token);
        this.debug("known:" + known + ": " + token.getSubject().getPrincipal().getName());
        return known;
    }

    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        Set tokens = super.getByCertificateDigest(digest);
        this.debug("bydigest:" + tokens.size() + ": " + digest.getHexValue());
        return tokens;
    }

    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        Set tokens = super.getByPublicKey(publicKey);
        try {
            this.debug("bykey:" + tokens.size() + ": " + Hex.toHexString((byte[])MessageDigest.getInstance("SHA1").digest(publicKey.getEncoded())));
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)e);
        }
        return tokens;
    }

    public Set<CertificateToken> getBySki(byte[] ski) {
        Set tokens = super.getBySki(ski);
        this.debug("byski:" + tokens.size() + ": " + Hex.toHexString((byte[])ski));
        return tokens;
    }

    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        Set tokens = super.getBySubject(subject);
        this.debug("bysubject:" + tokens.size() + ": " + subject.getPrincipal().getName());
        return tokens;
    }

    public synchronized List<TrustProperties> getTrustServices(CertificateToken token) {
        List trustServices = super.getTrustServices(token);
        this.debug("trustservices:" + trustServices.size() + ": " + token.getSubject().getPrincipal().getName());
        return trustServices;
    }

    private void debug(String value) {
        log.debug((Object)value);
    }

    @Generated
    public TLValidationJob getValidationJob() {
        return this.validationJob;
    }

    @Generated
    public BigInteger getTslVersionIdentifier() {
        return this.tslVersionIdentifier;
    }

    @Generated
    public BigInteger getTslSequenceNumber() {
        return this.tslSequenceNumber;
    }

    @Generated
    public String getTslType() {
        return this.tslType;
    }

    @Generated
    public Calendar getIssueDate() {
        return this.issueDate;
    }

    @Generated
    public Calendar getNextUpdate() {
        return this.nextUpdate;
    }

    @Generated
    public CommonsDataLoader getCommonsHttpDataLoader() {
        return this.commonsHttpDataLoader;
    }
}

