/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.tkmanager.TKManager;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.KeyStoreCertificateSource;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class TKManagerCertificateSource
extends KeyStoreCertificateSource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TKManagerCertificateSource.class);
    private TKManager manager;

    public TKManagerCertificateSource(TKManager manager) {
        super("JKS", "".toCharArray());
        this.manager = manager;
    }

    public List<CertificateToken> getCertificates() {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        try {
            Enumeration aliases = this.manager.getAlias();
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                X509Certificate cert = this.manager.getCertificate(alias);
                CertificateToken certToken = new CertificateToken(cert);
                certificateTokens.add(certToken);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return certificateTokens;
    }

    public CertificateToken getCertificate(String alias) {
        CertificateToken certToken = null;
        try {
            X509Certificate cert = this.manager.getCertificate(alias);
            certToken = new CertificateToken(cert);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return certToken;
    }
}

