/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources;

import com.anf.cryptotoken.api.sign.ANFSignatureToken;
import com.anf.cryptotoken.log.Logger;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.KeyStoreCertificateSource;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ANFTokenCertificateSource
extends KeyStoreCertificateSource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ANFTokenCertificateSource.class);
    private ANFSignatureToken manager;
    private String serial;
    private String alias;

    public ANFTokenCertificateSource(ANFSignatureToken manager, String serial, String alias) {
        super("JKS", "".toCharArray());
        this.manager = manager;
        this.serial = serial;
        this.alias = alias;
    }

    public ANFTokenCertificateSource(ANFSignatureToken manager, String serial) {
        this(manager, serial, null);
    }

    public List<CertificateToken> getCertificates() {
        ArrayList<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();
        try {
            if (this.alias != null) {
                certificateTokens.add(this.getCertificate(this.alias));
            } else {
                Enumeration aliases = this.manager.getSignAlias(this.serial);
                while (aliases.hasMoreElements()) {
                    String alias = (String)aliases.nextElement();
                    X509Certificate cert = this.manager.getSignCertificate(this.serial, alias);
                    CertificateToken certToken = new CertificateToken(cert);
                    certificateTokens.add(certToken);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return certificateTokens;
    }

    public CertificateToken getCertificate(String alias) {
        CertificateToken certToken = null;
        try {
            X509Certificate cert = this.manager.getSignCertificate(this.serial, alias);
            certToken = new CertificateToken(cert);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return certToken;
    }
}

