/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources;

import com.anf.timestamp.client.TSUClient;
import com.anf.timestamp.services.TSUController;
import com.anf.timestamp.services.TimeStampValidator;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;

public class ANFTSPSource
implements TSPSource {
    private static final Logger log = LogManager.getLogger(ANFTSPSource.class);
    private static final long serialVersionUID = 1L;
    private transient TSUController controller;
    private X509Certificate[] chain;

    public ANFTSPSource(TSUController controller, X509Certificate[] chain) {
        this.controller = controller;
        this.chain = chain;
    }

    public TimestampBinary getTimeStampResponse(DigestAlgorithm digestAlgorithm, byte[] digest) throws DSSException {
        double t1 = System.nanoTime();
        try {
            TSUClient client = this.controller.connectNextTSU(this.chain);
            byte[] tst = client.getTimeStampTokenEncoded(digestAlgorithm.getJavaName(), digest);
            TimeStampToken token = new TimeStampToken(new CMSSignedData(tst));
            log.info("timestamp token time: {}", (Object)token.getTimeStampInfo().getGenTime());
            TimeStampValidator.validateTimeStamp((TimeStampToken)token);
            TimestampBinary timestampBinary = new TimestampBinary(tst);
            return timestampBinary;
        }
        catch (IOException | CMSException | OperatorCreationException | TSPException e) {
            throw new DSSException(e);
        }
        finally {
            log.info("timestamp in " + ((double)System.nanoTime() - t1) / 1000000.0 + " ms");
        }
    }

    private void waitASecond() {
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

