/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.verifier.sources;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.ocsp.OnlineOCSPSource;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ANFOnlineOCSPSource
extends OnlineOCSPSource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(ANFOnlineOCSPSource.class);
    private Map<String, OCSPToken> cachedOCSPTokens = new TreeMap<String, OCSPToken>();

    public ANFOnlineOCSPSource() {
    }

    public ANFOnlineOCSPSource(DataLoader dataLoader) {
        super(dataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        double t1 = System.nanoTime();
        log.debug("get revocation token of {} with ID {}", (Object)certificateToken.getSubject().getPrincipal(), (Object)certificateToken.getDSSId().asXmlId());
        String key = Base64.getEncoder().encodeToString(certificateToken.getSignature());
        Map<String, OCSPToken> map = this.cachedOCSPTokens;
        synchronized (map) {
            OCSPToken revocationToken = this.cachedOCSPTokens.get(key);
            this.cachedOCSPTokens.clear();
            Calendar update = Calendar.getInstance();
            update.add(12, -5);
            if (revocationToken == null || revocationToken.getCreationDate().before(update.getTime())) {
                revocationToken = super.getRevocationToken(certificateToken, issuerCertificateToken);
                this.cachedOCSPTokens.put(key, revocationToken);
            }
            if (revocationToken == null) {
                log.debug("null revocation token");
            } else {
                log.info("revocation token time: {}", (Object)revocationToken.getThisUpdate());
            }
            log.info("ocsp in {} ms", (Object)(((double)System.nanoTime() - t1) / 1000000.0));
            return revocationToken;
        }
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, List<String> alternativeUrls) {
        log.debug("get revocation token of {} with issuer {}, urls: {}", (Object)certificateToken.getSubject().getPrincipal(), (Object)issuerCertificateToken.getSubject().getPrincipal(), alternativeUrls);
        OCSPToken revocationToken = super.getRevocationToken(certificateToken, issuerCertificateToken, alternativeUrls);
        if (revocationToken == null) {
            log.debug("null revocation token");
        }
        return revocationToken;
    }
}

