/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator.impl;

import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.result.XadesSignatureResult;
import com.anf.cryptotoken.sign.validation.validator.AbstractValidator;
import com.anf.cryptotoken.sign.validation.validator.XadesValidator;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmldsig.XmlDSigUtils;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XadesValidatorImpl
extends AbstractValidator<XadesSignatureResult>
implements XadesValidator {
    private static final Logger log = LogManager.getLogger(XadesValidatorImpl.class);
    private final LevelConstraint ignore = new LevelConstraint();

    public XadesValidatorImpl(ANFCertificateVerifier verifier) {
        super(verifier);
        this.ignore.setLevel(Level.IGNORE);
    }

    public XadesValidatorImpl(ANFCertificateVerifier verifier, SignedDocumentValidator validator) {
        super(verifier, validator);
        this.ignore.setLevel(Level.IGNORE);
    }

    @Override
    public void verifySignatures(SignedDocumentValidator validator, VerificationResult pvr) {
        validator.setCertificateVerifier((CertificateVerifier)this.verifier);
        validator.setSignaturePolicyProvider(this.verifier.getSignaturePolicyProvider());
        ValidationPolicy validationPolicy = this.validationPolicy(validator);
        Reports reports = validationPolicy == null ? validator.validateDocument() : validator.validateDocument(validationPolicy);
        pvr.setReportGenerator(reports);
        validator.getSignatures().forEach(signature -> {
            DefaultAdvancedSignature sign = (DefaultAdvancedSignature)signature;
            XadesSignatureResult result = new XadesSignatureResult(this.verifier, reports, sign, this.isOCSPValidation());
            List originalDocuments = validator.getOriginalDocuments(signature);
            if (!originalDocuments.isEmpty()) {
                result.setOriginalContent((DSSDocument)originalDocuments.get(0));
            }
            pvr.addSignatureResult(result);
        });
    }

    private ValidationPolicy validationPolicy(SignedDocumentValidator validator) {
        boolean xmldsig = this.isXmlDSig(validator);
        ValidationPolicy validationPolicy = null;
        if (xmldsig) {
            try {
                validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
                validationPolicy.getSignatureConstraints().getSignedAttributes().setSigningTime(this.ignore);
                validationPolicy.getSignatureConstraints().getSignedAttributes().setMessageDigestOrSignedPropertiesPresent(this.ignore);
                validationPolicy.getSignatureConstraints().getSignedAttributes().setSigningCertificatePresent(this.ignore);
                log.info("validando firma xmldsig con politica de validacion personalizada");
            }
            catch (JAXBException | IOException | XMLStreamException | SAXException e1) {
                throw new IllegalInputException("Unable to load the policy", e1);
            }
        }
        return validationPolicy;
    }

    private boolean isXmlDSig(SignedDocumentValidator validator) {
        List signatures = validator.getSignatures();
        boolean xmldsig = false;
        for (AdvancedSignature sig : signatures) {
            if (!(sig instanceof XAdESSignature)) continue;
            XAdESSignature xades = (XAdESSignature)sig;
            Element signatureElement = xades.getSignatureElement();
            List messages = XmlDSigUtils.getInstance().validateAgainstXSD((Source)new DOMSource(signatureElement));
            if (!messages.isEmpty()) continue;
            NodeList childs = signatureElement.getChildNodes();
            TreeSet<String> mustContains = new TreeSet<String>(List.of("SignedInfo", "SignatureValue", "KeyInfo"));
            String xmlns = signatureElement.getAttribute("xmlns");
            xmldsig = xmlns != null && xmlns.equals(XMLDSigNamespace.NS.getUri());
            for (int i = 0; xmldsig && i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                xmldsig = mustContains.contains(child.getLocalName());
            }
        }
        return xmldsig;
    }

    @Override
    public SignaturePackaging getSignaturePackaging(File file) throws IOException {
        List signatures;
        Iterator iterator;
        SignedDocumentValidator validator = this.createDSSValidator(file);
        Document rootElement = null;
        if (validator instanceof XMLDocumentValidator) {
            XMLDocumentValidator xmlValidator = (XMLDocumentValidator)validator;
            rootElement = xmlValidator.getRootElement();
            System.out.println(rootElement.getNodeName());
        }
        if ((iterator = (signatures = validator.getSignatures()).iterator()).hasNext()) {
            XAdESSignature xades;
            List references;
            AdvancedSignature sign = (AdvancedSignature)iterator.next();
            if (sign instanceof XAdESSignature && !(references = (xades = (XAdESSignature)sign).getReferences()).isEmpty()) {
                for (Reference reference : references) {
                    try {
                        String objectId;
                        Node objectById;
                        try {
                            Transforms transforms = reference.getTransforms();
                            if (transforms != null) {
                                int total = transforms.getLength();
                                for (int i = 0; i < total; ++i) {
                                    Transform transform = transforms.item(i);
                                    if (transform == null || transform.getURI() == null || !transform.getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") && !transform.getURI().equals("http://www.w3.org/2002/06/xmldsig-filter2")) continue;
                                    return SignaturePackaging.ENVELOPED;
                                }
                            }
                        }
                        catch (XMLSecurityException e) {
                            log.warn("error verificando transformaciones del xml", (Throwable)e);
                        }
                        if (DSSXMLUtils.isSignedProperties((Reference)reference, (XAdESPath)xades.getXAdESPaths()) || (objectById = xades.getObjectById(objectId = DomUtils.getId((String)reference.getURI()))) != null || objectId == null || objectId.isEmpty()) continue;
                        return SignaturePackaging.DETACHED;
                    }
                    catch (DSSException e) {
                        e.printStackTrace();
                    }
                }
            }
            return SignaturePackaging.ENVELOPING;
        }
        return null;
    }
}

