/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator.impl;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.result.SMIMESignatureResult;
import com.anf.cryptotoken.sign.validation.smime.MIMEHandler;
import com.anf.cryptotoken.sign.validation.validator.SMimeValidator;
import com.anf.cryptotoken.sign.validation.validator.impl.CadesValidatorImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import com.anf.cryptotoken.utils.AdditionalSignatureInformation;
import com.anf.cryptotoken.utils.CMSUtils;
import com.sun.mail.util.BASE64DecoderStream;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.jvnet.mimepull.MIMEPart;

public class SMIMEValidatorImpl
extends CadesValidatorImpl
implements SMimeValidator {
    private static final Logger log = Logger.getLogger(SMIMEValidatorImpl.class);
    private File signedFile;

    public SMIMEValidatorImpl(ANFCertificateVerifier verifier) {
        super(verifier);
    }

    public SMIMEValidatorImpl(ANFCertificateVerifier verifier, SignedDocumentValidator validator) {
        super(verifier, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerificationResult verifySignatures(File file) throws IOException {
        VerificationResult verificationResult = new VerificationResult();
        try (MIMEHandler handler = new MIMEHandler(file);){
            if (handler.getSignatures() != null && !handler.getSignatures().isEmpty()) {
                String fname = handler.getFileName();
                if (fname == null) {
                    fname = file.getName();
                }
                File contentFile = handler.getContentFile();
                CMSProcessableFile cmsProcessableFile = new CMSProcessableFile(contentFile);
                int signatureCounter = 1;
                for (int f = 0; f < handler.getSignatures().size(); ++f) {
                    try {
                        MimeBodyPart firma = MIMEHandler.convertToBodyPart(handler.getSignatures().get(f));
                        AdditionalSignatureInformation aditionalInfo = this.getAditionalInfo(firma);
                        Object id = "";
                        id = signatureCounter++ + ": " + firma.getDescription();
                        BASE64DecoderStream stream = (BASE64DecoderStream)firma.getContent();
                        this.extractCadesResult(fname, verificationResult, (CMSProcessable)cmsProcessableFile, aditionalInfo, (String)id, (InputStream)stream);
                        continue;
                    }
                    catch (Throwable e) {
                        log.error((Object)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return verificationResult;
    }

    public AdditionalSignatureInformation getAditionalInfo(MimeBodyPart firma) throws MessagingException {
        return new AdditionalSignatureInformation(firma.getDescription());
    }

    private void extractCadesResult(String sourceFileName, VerificationResult cvr, CMSProcessable cmsProcessableFile, AdditionalSignatureInformation aditionalInfo, String id, InputStream stream) throws IOException, MessagingException, CMSException {
        SMIMESignatureResult res = null;
        Object data = CMSUtils.extractCMS((CMSProcessable)cmsProcessableFile, (InputStream)stream);
        if (data != null) {
            if (data instanceof CMSSignedData) {
                CMSSignedData cms = (CMSSignedData)data;
                try {
                    InMemoryDocument document = new InMemoryDocument(cms.getEncoded());
                    SignedDocumentValidator validator = SignedDocumentValidator.fromDocument((DSSDocument)document);
                    validator.setCertificateVerifier((CertificateVerifier)this.verifier);
                    validator.setEnableEtsiValidationReport(true);
                    validator.setValidationLevel(ValidationLevel.ARCHIVAL_DATA);
                    validator.setDetachedContents(Arrays.asList(new FileDocument((File)cmsProcessableFile.getContent())));
                    Reports reports = validator.validateDocument(this.validationPolicy);
                    List signatures = validator.getSignatures();
                    if (!signatures.isEmpty()) {
                        DefaultAdvancedSignature sign = (DefaultAdvancedSignature)signatures.get(0);
                        res = new SMIMESignatureResult(this.verifier, sourceFileName, reports, sign, this.isOCSPValidation());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                if (res == null) {
                    res = new SMIMESignatureResult(id, (CMSSignedData)data, aditionalInfo, this.isOCSPValidation());
                }
            } else if (data instanceof CMSTimeStampedData) {
                CMSTimeStampedData cmstsd = (CMSTimeStampedData)data;
                res = new SMIMESignatureResult(id, cmstsd, cmsProcessableFile, aditionalInfo, this.isOCSPValidation());
            }
        }
        if (res != null) {
            cvr.addSignatureResult(res);
        }
    }

    @Override
    public void verifySignatures(SignedDocumentValidator validator, VerificationResult pvr) {
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isARSignature(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSignedContentOldCades(File file, OutputStream out) {
        boolean done = false;
        try {
            block17: {
                try (MIMEHandler handler = new MIMEHandler(file);){
                    MIMEPart contentPart = handler.getContentPart();
                    done = false;
                    if (contentPart == null) break block17;
                    String fname = handler.getFileName();
                    if (fname == null) {
                        fname = file.getName();
                    }
                    File contentFile = handler.getContentFile();
                    System.out.println("content file:" + contentFile.getCanonicalPath() + " exists: " + contentFile.exists() + " size:" + contentFile.length());
                    try (FileInputStream in = new FileInputStream(contentFile);){
                        BASE64DecoderStream decoder = new BASE64DecoderStream((InputStream)in);
                        IOUtils.copy((InputStream)decoder, (OutputStream)out);
                        out.close();
                        done = true;
                    }
                    catch (Exception e) {
                        BASE64DecoderStream decoder = new BASE64DecoderStream(handler.getContentStream());
                        IOUtils.copy((InputStream)decoder, (OutputStream)out);
                        out.close();
                        done = true;
                    }
                }
            }
            if (!done) {
                byte[] signed = IOUtils.toByteArray((InputStream)new FileInputStream(file));
                CMSSignedData data = null;
                Object signedData = SMIMEValidatorImpl.isTSP(signed);
                if (signedData != null && signedData instanceof CMSTimeStampedData) {
                    CMSTimeStampedData tsdata = (CMSTimeStampedData)signedData;
                    data = new CMSSignedData(tsdata.getContent());
                } else {
                    data = new CMSSignedData(signed);
                }
                Object contentObject = data.getSignedContent().getContent();
                if (contentObject instanceof byte[]) {
                    IOUtils.write((byte[])((byte[])contentObject), (OutputStream)out);
                    out.close();
                    done = true;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return done;
    }

    public static Object isTSP(byte[] signed) throws MessagingException {
        try {
            CMSTimeStampedData tsd = new CMSTimeStampedData(signed);
            return tsd;
        }
        catch (IOException e) {
            log.error((Object)("this file is not TSP: NO CMSTimeStampedData: " + e.getMessage()));
            return null;
        }
    }

    public boolean isTSP(MimeBodyPart firma) throws MessagingException {
        AdditionalSignatureInformation adinfo = this.getAditionalInfo(firma);
        boolean hasHora = !adinfo.getHoraOCSP().isEmpty();
        return hasHora;
    }

    @Override
    public ByteArrayOutputStream getSignedContent(File file) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getSignedContent(file, (OutputStream)out);
        return out;
    }

    public boolean getSignedContent(File file, OutputStream out) {
        try {
            MIMEHandler handler = new MIMEHandler(file);
            return this.getSignedContent(handler, out);
        }
        catch (Throwable e) {
            log.error((Object)("no se pudo extraer el contenido original de la firma AR del archivo " + file), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSignedContent(MIMEHandler handler, OutputStream out) throws IOException {
        try {
            if (handler.getSignatures() != null && !handler.getSignatures().isEmpty()) {
                byte[] signedContent = handler.getSignedContent();
                out.write(signedContent);
                boolean bl = signedContent.length > 0;
                return bl;
            }
        }
        finally {
            handler.close();
        }
        return false;
    }

    public String getSignedFileName(File file) {
        FileDataSource ds = new FileDataSource(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SMIMEValidatorImpl.getFileName((DataSource)ds);
        return new String(out.toByteArray());
    }

    public String getSignedFileName(byte[] content) {
        ByteArrayDataSource ds = new ByteArrayDataSource(content, "application/pkcs7-signature");
        return SMIMEValidatorImpl.getFileName((DataSource)ds);
    }

    @Override
    public ByteArrayOutputStream getSignedContent(byte[] content) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (content != null) {
            try {
                MIMEHandler handler = new MIMEHandler(content, UUID.randomUUID().toString() + ".slc");
                this.getSignedContent(handler, (OutputStream)out);
            }
            catch (Throwable e) {
                log.error((Object)("no se pudo extraer el contenido original de la firma AR del contenido " + content.length), e);
            }
        }
        return out;
    }

    @Override
    public boolean getSignedContent(File file, File output) throws IOException {
        log.debug((Object)("extrayendo contenido firmado de " + file + " a " + output));
        try (FileOutputStream out = new FileOutputStream(output);){
            boolean bl = this.getSignedContent(file, (OutputStream)out);
            return bl;
        }
    }

    @Deprecated
    private boolean getSignedContent(DataSource ds, OutputStream out) {
        block18: {
            try {
                MimeMultipart mp = new MimeMultipart(ds);
                if (mp.getCount() < 2) break block18;
                MimeBodyPart documento = (MimeBodyPart)mp.getBodyPart(0);
                byte[] content = null;
                String encoding = documento.getEncoding();
                if (encoding != null && encoding.equalsIgnoreCase("base64") && documento.getContent() instanceof BASE64DecoderStream) {
                    BASE64DecoderStream decoder = (BASE64DecoderStream)documento.getContent();
                    content = IOUtils.toByteArray((InputStream)decoder);
                } else if (encoding != null && encoding.equalsIgnoreCase("base64") && documento.getContent() instanceof String) {
                    content = ((String)documento.getContent()).getBytes();
                } else if (mp.getContentType() != null && mp.getContentType().equals("application/octet-stream") && documento.getContent() instanceof String) {
                    content = ((String)documento.getContent()).getBytes();
                    try {
                        byte[] decoded = Base64.getMimeDecoder().decode(content);
                        if (decoded != null && decoded.length > 0) {
                            content = decoded;
                        }
                    }
                    catch (Exception decoded) {}
                } else if (encoding.equals("7bit")) {
                    if (this.signedFile != null) {
                        SMIMEValidatorImpl.getSignedContentOldCades(this.signedFile, out);
                    } else {
                        try {
                            content = ((String)documento.getContent()).getBytes();
                            byte[] decoded = Base64.getMimeDecoder().decode(content);
                            if (decoded != null && decoded.length > 0) {
                                content = decoded;
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)"error decodificando el contenido", (Throwable)e);
                        }
                    }
                }
                if (content != null) {
                    out.write(content);
                    return true;
                }
            }
            catch (MessagingException | IOException e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    private static String getFileName(DataSource ds) {
        try {
            MimeMultipart mp = new MimeMultipart(ds);
            if (mp.getCount() >= 2) {
                return mp.getBodyPart(0).getFileName();
            }
        }
        catch (MessagingException e) {
            log.error((Object)e);
        }
        return null;
    }
}

