/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator.impl;

import com.anf.cryptotoken.sign.validation.VerificationResult;
import com.anf.cryptotoken.sign.validation.result.CadesSignatureResult;
import com.anf.cryptotoken.sign.validation.validator.AbstractValidator;
import com.anf.cryptotoken.sign.validation.validator.CadesValidator;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.cms.CMSTypedData;

public class CadesValidatorImpl
extends AbstractValidator<CadesSignatureResult>
implements CadesValidator {
    public CadesValidatorImpl(ANFCertificateVerifier verifier) {
        super(verifier);
    }

    public CadesValidatorImpl(ANFCertificateVerifier verifier, SignedDocumentValidator validator) {
        super(verifier, validator);
    }

    @Override
    public void verifySignatures(SignedDocumentValidator validator, VerificationResult pvr) {
        Reports reports = validator.validateDocument(this.validationPolicy);
        pvr.setReportGenerator(reports);
        validator.getSignatures().forEach(signature -> {
            DefaultAdvancedSignature sign = (DefaultAdvancedSignature)signature;
            CadesSignatureResult result = new CadesSignatureResult(this.verifier, reports, sign, this.isOCSPValidation());
            List originalDocuments = validator.getOriginalDocuments(signature);
            if (!originalDocuments.isEmpty()) {
                result.setOriginalContent((DSSDocument)originalDocuments.get(0));
            }
            pvr.addSignatureResult(result);
        });
    }

    @Override
    public SignaturePackaging getSignaturePackaging(File file) throws IOException {
        SignedDocumentValidator validator = this.createDSSValidator(file);
        List signatures = validator.getSignatures();
        for (AdvancedSignature sign : signatures) {
            CAdESSignature cades;
            CMSTypedData signedContent;
            if (!(sign instanceof CAdESSignature) || (signedContent = (cades = (CAdESSignature)sign).getCmsSignedData().getSignedContent()) != null) continue;
            return SignaturePackaging.DETACHED;
        }
        return SignaturePackaging.ENVELOPING;
    }
}

