/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.validator.factory;

import com.anf.cryptotoken.sign.pades.factory.PdfSignatureObjectFactoryServiceLocator;
import com.anf.cryptotoken.sign.validation.exception.SignatureNotDetectedException;
import com.anf.cryptotoken.sign.validation.validator.CadesValidator;
import com.anf.cryptotoken.sign.validation.validator.PadesValidator;
import com.anf.cryptotoken.sign.validation.validator.SMimeValidator;
import com.anf.cryptotoken.sign.validation.validator.SignatureValidator;
import com.anf.cryptotoken.sign.validation.validator.XadesValidator;
import com.anf.cryptotoken.sign.validation.validator.factory.SignatureType;
import com.anf.cryptotoken.sign.validation.validator.impl.AsicCadesValidatorImpl;
import com.anf.cryptotoken.sign.validation.validator.impl.AsicXadesValidatorImpl;
import com.anf.cryptotoken.sign.validation.validator.impl.CadesValidatorImpl;
import com.anf.cryptotoken.sign.validation.validator.impl.PadesValidatorImpl;
import com.anf.cryptotoken.sign.validation.validator.impl.SMIMEValidatorImpl;
import com.anf.cryptotoken.sign.validation.validator.impl.XadesValidatorImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateSourceFactory;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESValidator;
import eu.europa.esig.dss.asic.xades.validation.ASiCContainerWithXAdESValidator;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.service.crl.OnlineCRLSource;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.service.ocsp.OnlineOCSPSource;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidatorFactory {
    private static final Logger log = LogManager.getLogger(ValidatorFactory.class);
    private ANFCertificateVerifier verifier;

    public ValidatorFactory() {
        this((CertificateSource)ANFCertificateSourceFactory.getTslCertificateSource());
    }

    public ValidatorFactory(CertificateSource tslSource) {
        this.verifier = new ANFCertificateVerifier(tslSource);
    }

    public SignatureType detectSignatureType(byte[] signedFile) {
        InMemoryDocument doc = new InMemoryDocument(signedFile);
        SignedDocumentValidator validator = this.buildValidator(doc);
        return this.detectSignatureType((DSSDocument)doc, validator);
    }

    public SignatureType detectSignatureType(File signedFile) {
        FileDocument doc = new FileDocument(signedFile);
        SignedDocumentValidator validator = SignedDocumentValidator.fromDocument((DSSDocument)doc);
        return this.detectSignatureType((DSSDocument)doc, validator);
    }

    private SignatureType detectSignatureType(DSSDocument document, SignedDocumentValidator validator) {
        SignatureType type = SignatureType.UNSIGNED;
        try {
            if (validator instanceof CMSDocumentValidator) {
                type = SignatureType.CADES;
            } else if (validator instanceof PDFDocumentValidator) {
                type = SignatureType.PADES;
            } else if (validator instanceof XMLDocumentValidator) {
                type = SignatureType.XADES;
            } else if (validator instanceof ASiCContainerWithCAdESValidator) {
                type = SignatureType.ASIC_CADES;
            } else if (validator instanceof ASiCContainerWithXAdESValidator) {
                type = SignatureType.ASIC_XADES;
            }
        }
        catch (Exception e) {
            if (document instanceof FileDocument) {
                FileDocument fileDoc = (FileDocument)document;
                if (this.smimeValidator().isARSignature(fileDoc.getFile())) {
                    type = SignatureType.SMIME;
                }
            }
            type = SignatureType.UNSIGNED;
        }
        return type;
    }

    public SignatureValidator buildValidator(byte[] signedFile) throws SignatureNotDetectedException {
        InMemoryDocument doc = new InMemoryDocument(signedFile);
        SignedDocumentValidator validator = this.buildValidator(doc);
        return this.buildValidator((DSSDocument)doc, validator);
    }

    private SignedDocumentValidator buildValidator(InMemoryDocument doc) {
        try {
            return SignedDocumentValidator.fromDocument((DSSDocument)doc);
        }
        catch (Exception e) {
            log.warn("no se pudo construir el validador para el archivo {}", (Object)doc, (Object)e);
            return null;
        }
    }

    public SignatureValidator buildValidator(File signedFile) throws SignatureNotDetectedException {
        FileDocument doc = new FileDocument(signedFile);
        SignedDocumentValidator validator = SignedDocumentValidator.fromDocument((DSSDocument)doc);
        return this.buildValidator((DSSDocument)doc, validator);
    }

    private SignatureValidator buildValidator(DSSDocument doc, SignedDocumentValidator validator) {
        if (validator == null) {
            FileDocument fileDoc;
            SMimeValidator smimeValidator = this.smimeValidator();
            if (doc instanceof FileDocument && smimeValidator.isARSignature((fileDoc = (FileDocument)doc).getFile())) {
                return smimeValidator;
            }
            return null;
        }
        validator.setCertificateVerifier((CertificateVerifier)this.verifier);
        validator.setEnableEtsiValidationReport(true);
        validator.setValidationLevel(ValidationLevel.ARCHIVAL_DATA);
        validator.setLocale(new Locale("es"));
        validator.setIncludeSemantics(true);
        validator.setValidationTime(new Date());
        if (validator instanceof CMSDocumentValidator) {
            return new CadesValidatorImpl(this.verifier, validator);
        }
        if (validator instanceof PDFDocumentValidator) {
            PDFDocumentValidator pdfValidtor = (PDFDocumentValidator)validator;
            long fileSize = 0L;
            if (doc instanceof InMemoryDocument) {
                InMemoryDocument memoryDoc = (InMemoryDocument)doc;
                fileSize = memoryDoc.getBytes().length;
            } else if (doc instanceof FileDocument) {
                FileDocument fileDoc = (FileDocument)doc;
                fileSize = fileDoc.getFile().length();
            }
            pdfValidtor.setPdfObjFactory((IPdfObjFactory)PdfSignatureObjectFactoryServiceLocator.getSignatureObjectFactory(fileSize < 0x100000L));
            return new PadesValidatorImpl(this.verifier, validator);
        }
        if (validator instanceof XMLDocumentValidator) {
            return new XadesValidatorImpl(this.verifier, validator);
        }
        if (validator instanceof ASiCContainerWithCAdESValidator) {
            return new AsicCadesValidatorImpl(this.verifier, validator);
        }
        if (validator instanceof ASiCContainerWithXAdESValidator) {
            return new AsicXadesValidatorImpl(this.verifier, validator);
        }
        return null;
    }

    public CadesValidator cadesValidator() {
        return new CadesValidatorImpl(this.verifier);
    }

    public PadesValidator padesValidator() {
        return new PadesValidatorImpl(this.verifier);
    }

    public XadesValidator xadesValidator() {
        return new XadesValidatorImpl(this.verifier);
    }

    public SMimeValidator smimeValidator() {
        return new SMIMEValidatorImpl(this.verifier);
    }

    public SMimeValidator arValidator() {
        return this.smimeValidator();
    }

    public ValidatorFactory setTrustSource(CertificateSource source) {
        if (this.verifier == null) {
            this.verifier = new ANFCertificateVerifier(source);
        }
        this.verifier.setTrustedCertSources(new CertificateSource[]{source});
        return this;
    }

    public ValidatorFactory checkCRLRevocation(boolean useCRL) {
        if (this.verifier == null) {
            this.verifier = new ANFCertificateVerifier(new CertificateSource[0]);
        }
        if (useCRL) {
            CommonsDataLoader crlDataLoader = new CommonsDataLoader();
            crlDataLoader.setTimeoutConnection(30000);
            crlDataLoader.setTimeoutSocket(30000);
            OnlineCRLSource crlSource = new OnlineCRLSource((DataLoader)crlDataLoader);
            this.verifier.setCrlSource((RevocationSource)crlSource);
        } else {
            this.verifier.setCrlSource(null);
        }
        return this;
    }

    public ValidatorFactory setCRLSource(OnlineCRLSource crlSource) {
        if (this.verifier == null) {
            this.verifier = new ANFCertificateVerifier(new CertificateSource[0]);
        }
        this.verifier.setCrlSource((RevocationSource)crlSource);
        return this;
    }

    public ValidatorFactory checkOCSPRevocation(boolean useOCSP) {
        if (this.verifier == null) {
            this.verifier = new ANFCertificateVerifier(new CertificateSource[0]);
        }
        if (!useOCSP) {
            this.verifier.setOcspSource(null);
        }
        return this;
    }

    public ValidatorFactory setOCSPSource(OnlineOCSPSource ocspSource) {
        if (this.verifier == null) {
            this.verifier = new ANFCertificateVerifier(new CertificateSource[0]);
        }
        this.verifier.setOcspSource((RevocationSource)ocspSource);
        return this;
    }

    public SignedDocumentValidator createDSSValidator(File file) {
        FileDocument document = new FileDocument(file);
        SignedDocumentValidator fileValidator = SignedDocumentValidator.fromDocument((DSSDocument)document);
        fileValidator.setCertificateVerifier((CertificateVerifier)this.verifier);
        fileValidator.setEnableEtsiValidationReport(true);
        fileValidator.setValidationLevel(ValidationLevel.ARCHIVAL_DATA);
        if (fileValidator instanceof PDFDocumentValidator) {
            PDFDocumentValidator pdfValidator = (PDFDocumentValidator)fileValidator;
            pdfValidator.setPdfObjFactory((IPdfObjFactory)PdfSignatureObjectFactoryServiceLocator.getSignatureObjectFactory(file.length() < 0x100000L));
        }
        return fileValidator;
    }

    public DetachedTimestampValidator detachedTimestampValidator(byte[] timestamp, File ... files) {
        DetachedTimestampValidator val = new DetachedTimestampValidator((DSSDocument)new InMemoryDocument(timestamp));
        val.setCertificateVerifier((CertificateVerifier)this.verifier);
        if (files != null && files.length > 0) {
            ArrayList<FileDocument> list = new ArrayList<FileDocument>();
            for (File file : files) {
                list.add(new FileDocument(file));
            }
            val.setDetachedContents(list);
        }
        return val;
    }
}

