/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.tsu;

import com.anf.cert.utils.CertUtils;
import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.ocsp.OCSPHandler;
import com.anf.cryptotoken.ocsp.OCSPHandlerFactory;
import com.anf.cryptotoken.sign.validation.TimeStampData;
import com.anf.timestamp.services.TimeStampValidator;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;

public class TimeStampDataImpl
implements TimeStampData,
Serializable {
    private static final Logger log = Logger.getLogger(TimeStampDataImpl.class);
    private static final long serialVersionUID = 1L;
    private TimeStampToken tst;
    private X509Certificate[] tsCertificates;
    private X509Certificate tsaCert;
    private boolean isTimeStampSignature;
    private boolean validateTimeStamp;
    private boolean verifyTimeStamp;
    private List<CertStatus> timeStampCertificateChainStatus;
    protected ArrayList<Throwable> errors = new ArrayList();
    private CMSTimeStampedData timeStampedData;
    private boolean vigentOnSignTime;
    private Date revocationTime = null;
    private TimestampToken timestampToken;
    private OCSPHandler ocspHandler = OCSPHandlerFactory.ocspHandler();

    public TimeStampDataImpl(TimeStampToken token, CMSTimeStampedData tsdata, boolean doOCSPValidation) throws TSPException, IOException, CMSException {
        this(new TimestampToken(token.getEncoded(), TimestampType.SIGNATURE_TIMESTAMP), tsdata, doOCSPValidation);
    }

    public TimeStampDataImpl(TimestampToken timestampToken, boolean verifyTimeStamp, boolean doOCSPValidation) throws TSPException {
        this(timestampToken, null, doOCSPValidation);
        this.verifyTimeStamp = verifyTimeStamp;
    }

    public TimeStampDataImpl(TimestampToken timestampToken, CMSTimeStampedData timeStampedData, boolean doOCSPValidation) throws TSPException {
        this.timestampToken = timestampToken;
        boolean bl = this.isTimeStampSignature = timestampToken != null;
        if (this.isTimeStampSignature) {
            List statusList;
            this.tst = timestampToken.getTimeStamp();
            this.isTimeStampSignature = this.tst != null;
            List<X509Certificate> certificates = timestampToken.getCertificates().stream().map(CertificateToken::getCertificate).collect(Collectors.toList());
            this.tsCertificates = new X509Certificate[certificates.size()];
            certificates.toArray(this.tsCertificates);
            this.tsCertificates = CertUtils.sortChain((X509Certificate[])this.tsCertificates);
            int finalCert = CertUtils.getFinalCert((X509Certificate[])this.tsCertificates);
            if (finalCert != -1) {
                this.tsaCert = this.tsCertificates[finalCert];
                timestampToken.isSignedBy(new CertificateToken(this.tsaCert));
            }
            if (this.tsCertificates.length == 1) {
                this.tsCertificates = CertUtils.buildChain((X509Certificate[])this.tsCertificates);
            }
            this.timeStampCertificateChainStatus = this.ocspHandler.verifyCertificateChain(this.tsCertificates);
            try {
                if (timestampToken != null && !this.verifyTimeStamp) {
                    this.verifyTimeStamp = timestampToken.isSignatureIntact() && timestampToken.isValid();
                }
                this.validateTimeStamp = TimeStampValidator.validateTimeStamp((TimeStampToken)this.tst);
                if (timeStampedData != null) {
                    this.verifyTimeStamp = TimeStampValidator.verifyTimeStamp((TimeStampToken)this.tst, (byte[])timeStampedData.getContent());
                }
            }
            catch (OperatorCreationException | TSPException e) {
                this.errors.add(e);
            }
            if (doOCSPValidation && (statusList = this.ocspHandler.validateOCSPCertificateChain(this.tsCertificates)).size() == this.timeStampCertificateChainStatus.size()) {
                for (int i = 0; i < statusList.size(); ++i) {
                    CertStatus certStatus = (CertStatus)statusList.get(i);
                    if (certStatus.getOcspResponse() != null) {
                        this.timeStampCertificateChainStatus.get(i).setOcspResponse(certStatus.getOcspResponse());
                    }
                    if (certStatus.getStatusOCSP() == null) continue;
                    this.timeStampCertificateChainStatus.get(i).setStatusOCSP(certStatus.getStatusOCSP());
                }
            }
            System.out.println("finalCert " + finalCert);
            System.out.println("timeStampCertificateChainStatus " + this.timeStampCertificateChainStatus.size());
            if (finalCert != -1 && finalCert < this.timeStampCertificateChainStatus.size()) {
                CertStatus certChainStatus = this.timeStampCertificateChainStatus.get(finalCert);
                BasicOCSPResp ocspResp = certChainStatus.getOcspResponse();
                System.out.println("ocspResp " + ocspResp);
                if (ocspResp != null) {
                    SingleResp[] responses = ocspResp.getResponses();
                    System.out.println("responses " + responses.length);
                    if (responses != null && responses.length >= 1) {
                        SingleResp response = responses[0];
                        CertificateStatus ocspStatus = response.getCertStatus();
                        if (ocspStatus != null) {
                            if (ocspStatus instanceof RevokedStatus) {
                                RevokedStatus revokedStatus = (RevokedStatus)ocspStatus;
                                this.revocationTime = revokedStatus.getRevocationTime();
                                System.out.println("vigentOnSignTime " + this.revocationTime + " " + this.tst.getTimeStampInfo().getGenTime());
                                this.vigentOnSignTime = this.revocationTime.after(this.tst.getTimeStampInfo().getGenTime());
                            } else if (ocspStatus instanceof UnknownStatus) {
                                System.out.println("vigentOnSignTime UnknownStatus false");
                                this.vigentOnSignTime = false;
                            } else {
                                System.out.println("vigentOnSignTime Good true");
                                this.vigentOnSignTime = true;
                            }
                        } else if (certChainStatus.getStatusOCSP().contentEquals("Good")) {
                            System.out.println("vigentOnSignTime true status Good");
                            this.vigentOnSignTime = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public TimeStampToken getTst() {
        return this.tst;
    }

    public ArrayList<Throwable> getErrors() {
        return this.errors;
    }

    @Override
    public X509Certificate[] getTsCertificates() {
        return this.tsCertificates;
    }

    @Override
    public boolean isTimeStampSignature() {
        return this.isTimeStampSignature;
    }

    @Override
    public boolean isValidateTimeStamp() {
        return this.validateTimeStamp;
    }

    @Override
    public boolean isVerifyTimeStamp() {
        return this.verifyTimeStamp;
    }

    @Override
    public List<CertStatus> getTimeStampCertificateChainStatus() {
        return this.timeStampCertificateChainStatus;
    }

    @Override
    public CMSTimeStampedData getTimeStampedData() {
        return this.timeStampedData;
    }

    @Override
    public boolean isVigentOnSignTime() {
        return this.vigentOnSignTime;
    }

    @Override
    public X509Certificate getTsaCert() {
        return this.tsaCert;
    }

    @Override
    public Date getRevocationTime() {
        return this.revocationTime;
    }

    public TimestampToken getTimestampToken() {
        return this.timestampToken;
    }

    @Override
    public boolean validateTSACert() {
        X509Certificate cert;
        X509Certificate issuerCertificate;
        int finalCert;
        boolean isValid = false;
        if (this.tsCertificates != null && (finalCert = CertUtils.getFinalCert((X509Certificate[])this.tsCertificates)) != -1 && (issuerCertificate = CertUtils.getIssuerCertificate((X509Certificate[])this.tsCertificates, (X509Certificate)(cert = this.tsCertificates[finalCert]))) != null) {
            try {
                cert.verify(issuerCertificate.getPublicKey());
                isValid = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                log.error((Object)e);
            }
        }
        return isValid;
    }
}

