/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.smime;

import com.anf.cryptotoken.io.Files;
import com.anf.cryptotoken.log.Logger;
import com.sun.mail.util.BASE64EncoderStream;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEPart;

public class MIMEHandler
implements Closeable {
    private static final Logger log = Logger.getLogger(MIMEHandler.class);
    private Map<String, String> headerMap = null;
    private MIMEMessage msg = null;
    private MIMEPart contentPart;
    private InputStream contentStream = null;
    private List<MIMEPart> signatures = null;
    private File contentFile = null;
    private String fileName;

    protected void finalize() throws Throwable {
        log.info((Object)("finalizing MIMEHandler " + this + ". Eliminando contentFile:" + this.contentFile));
        if (this.contentFile != null && this.contentFile.exists()) {
            FileUtils.deleteQuietly((File)this.contentFile);
        }
        if (this.contentFile != null && this.contentFile.getParentFile().exists()) {
            FileUtils.deleteQuietly((File)this.contentFile.getParentFile());
        }
    }

    public MIMEHandler(File src) throws Throwable {
        this(FileUtils.readFileToByteArray((File)src), src.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMEHandler(byte[] content, String sourceFileName) throws Throwable {
        try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
            this.parseHeaders(new ByteArrayInputStream(content, 0, 1000));
            String boundary = this.getBoundary();
            if (boundary != null) {
                this.msg = new MIMEMessage((InputStream)is, boundary);
                List attachments = this.msg.getAttachments();
                log.debug((Object)("cantidad de partes en el mensaje mime " + attachments.size()));
                if (attachments.size() > 1) {
                    this.contentPart = this.msg.getPart(0);
                    String fileName = this.getFileName();
                    if (fileName == null) {
                        fileName = sourceFileName;
                    }
                    log.debug((Object)("el nombre del archivo original es " + fileName));
                    File dir = new File(Files.temp, UUID.randomUUID().toString());
                    dir.mkdirs();
                    dir.deleteOnExit();
                    this.contentStream = this.contentPart.readOnce();
                    this.contentFile = new File(dir, fileName);
                    byte[] sourceContent = IOUtils.toByteArray((InputStream)this.contentStream);
                    log.debug((Object)("escribiendo contenido del archivo original en " + this.contentFile));
                    FileUtils.writeByteArrayToFile((File)this.contentFile, (byte[])sourceContent);
                    this.contentStream = new FileInputStream(this.contentFile);
                    this.contentFile.deleteOnExit();
                    this.signatures = new ArrayList<MIMEPart>();
                    for (int i = 1; i < attachments.size(); ++i) {
                        log.debug((Object)("anadiendo parte de MIME " + i));
                        this.signatures.add((MIMEPart)attachments.get(i));
                    }
                } else if (attachments.size() == 1) {
                    log.debug((Object)"el archivo solo tiene una parte, el contenido");
                    MIMEPart part = this.msg.getPart(0);
                    this.contentStream = part.readOnce();
                } else {
                    log.debug((Object)"no es un archivo firmado, se lee el contenido del InputStream");
                    is.reset();
                    this.contentStream = is;
                }
            } else {
                log.debug((Object)"no es un archivo firmado, se lee el contenido del InputStream");
                is.reset();
                this.contentStream = is;
            }
        }
    }

    public byte[] getSignedContent() throws IOException {
        byte[] fileContent = FileUtils.readFileToByteArray((File)this.contentFile);
        if (this.contentPart.getContentTransferEncoding().equals("7bit")) {
            return Base64.getMimeDecoder().decode(fileContent);
        }
        return fileContent;
    }

    public String getFileName() {
        String st;
        int ind;
        String dis;
        List disposition;
        if (this.fileName != null) {
            return this.fileName;
        }
        String fileName = null;
        if (this.contentPart != null && !(disposition = this.contentPart.getHeader("Content-Disposition")).isEmpty() && (dis = (String)disposition.get(0)).startsWith("attachment") && (ind = dis.indexOf(st = "filename=")) != -1 && dis.length() > ind + st.length()) {
            fileName = new String(dis.substring(ind + st.length()).trim());
            if (fileName.startsWith("\"")) {
                fileName = fileName.substring(1);
            }
            if (fileName.endsWith("\"")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
        }
        return fileName;
    }

    private String parseHeaders(InputStream is) throws Throwable {
        String str;
        int startFileName;
        byte[] head = new byte[Math.min(1000, is.available())];
        long headRead = is.read(head);
        headRead = is.skip(-headRead);
        int c = 0;
        String header = new String(head, "ISO-8859-1");
        for (int i = 0; i < header.length(); ++i) {
            if (header.charAt(i) != '\n') continue;
            ++c;
        }
        if (c > 5 && this.looksLikeHeader(header)) {
            InternetHeaders ih = new InternetHeaders((InputStream)new ByteArrayInputStream(head));
            Enumeration allHeaders = ih.getAllHeaders();
            if (allHeaders.hasMoreElements()) {
                this.headerMap = new TreeMap<String, String>();
            }
            while (allHeaders.hasMoreElements()) {
                jakarta.mail.Header h = (jakarta.mail.Header)allHeaders.nextElement();
                this.headerMap.put(h.getName(), h.getValue());
            }
        }
        if ((startFileName = header.indexOf(str = "filename=\"")) == -1) {
            str = "filename=";
            startFileName = header.indexOf(str);
            if (startFileName != -1) {
                next = header.substring(startFileName + str.length());
                StringTokenizer tok = new StringTokenizer(next);
                this.fileName = tok.nextToken().replace("\r", "").replace("\n", "").trim();
            }
        } else {
            next = header.substring(startFileName + str.length());
            int endFileName = next.indexOf("\"");
            if (endFileName != -1) {
                this.fileName = next.substring(0, endFileName).replace("\r", "").replace("\n", "").trim();
            }
        }
        return null;
    }

    private boolean looksLikeHeader(String header) {
        try {
            InternetHeaders ih = new InternetHeaders((InputStream)new ByteArrayInputStream(header.getBytes()));
            Enumeration allHeaders = ih.getAllHeaders();
            int c = 0;
            while (allHeaders.hasMoreElements()) {
                jakarta.mail.Header h = (jakarta.mail.Header)allHeaders.nextElement();
                if (h.getName().equals(h.getValue())) continue;
                ++c;
            }
            return c >= 3;
        }
        catch (Throwable e) {
            log.error((Object)e);
            return false;
        }
    }

    private String getBoundary() {
        String str;
        int ind;
        String value;
        if (this.headerMap != null && (value = this.headerMap.get("Content-Type")) != null && (ind = value.indexOf(str = "boundary=\"")) != -1) {
            String sub = value.substring(ind);
            if (!sub.endsWith("\"")) {
                return null;
            }
            sub = sub.substring(str.length(), sub.length() - 1);
            return sub;
        }
        return null;
    }

    public List<MIMEPart> getSignatures() {
        return this.signatures;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public InputStream getNewContentStream() {
        return this.contentPart.readOnce();
    }

    public MIMEPart getContentPart() {
        return this.contentPart;
    }

    public MIMEMessage getMIMEMsg() {
        return this.msg;
    }

    public static MimeBodyPart convertToBodyPart(MIMEPart signx) throws MessagingException, IOException {
        List allHeaders = signx.getAllHeaders();
        InternetHeaders headers = new InternetHeaders();
        for (Header header : allHeaders) {
            headers.addHeader(header.getName(), header.getValue());
        }
        byte[] decBytes = IOUtils.toByteArray((InputStream)signx.readOnce());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream enc = new BASE64EncoderStream((OutputStream)bos);
        enc.write(decBytes);
        enc.close();
        MimeBodyPart part = new MimeBodyPart(headers, bos.toByteArray());
        return part;
    }

    public File getContentFile() {
        return this.contentFile;
    }

    @Override
    public void close() throws IOException {
        this.contentStream.close();
        log.info((Object)("cerrando el mime handler del archivo " + this.contentFile));
        try {
            this.finalize();
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
    }
}

