/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.result;

import com.anf.cryptotoken.log.Logger;
import com.anf.cryptotoken.sign.validation.impl.SignatureResultImpl;
import com.anf.cryptotoken.sign.verifier.ANFCertificateVerifier;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.bouncycastle.util.encoders.Hex;
import org.w3c.dom.Node;

public class XadesSignatureResult
extends SignatureResultImpl {
    private static final Logger log = Logger.getLogger(XadesSignatureResult.class);
    private static final long serialVersionUID = 1L;

    public XadesSignatureResult(ANFCertificateVerifier verifier, Reports reports, DefaultAdvancedSignature signature, boolean doOCSPValidation) {
        super(verifier, reports, signature, doOCSPValidation);
        XAdESSignature xades;
        List references;
        if (signature instanceof XAdESSignature && !(references = (xades = (XAdESSignature)signature).getReferences()).isEmpty()) {
            references.forEach(ref -> {
                try {
                    if (ref.getType() == null || ref.getType().isEmpty()) {
                        byte[] digest = ref.getDigestValue();
                        this.setContentHash(digest);
                        System.out.println("hash:" + new String(Hex.encode((byte[])digest)));
                    }
                }
                catch (XMLSecurityException e) {
                    e.printStackTrace();
                }
            });
            this.signaturePackaging = this.determineSignaturePackaging(xades, references);
        }
    }

    private SignaturePackaging determineSignaturePackaging(XAdESSignature xades, List<Reference> references) {
        for (Reference reference : references) {
            try {
                String objectId;
                Node objectById;
                try {
                    Transforms transforms = reference.getTransforms();
                    if (transforms != null) {
                        int total = transforms.getLength();
                        for (int i = 0; i < total; ++i) {
                            Transform transform = transforms.item(i);
                            if (transform == null || transform.getURI() == null || !transform.getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") && !transform.getURI().equals("http://www.w3.org/2002/06/xmldsig-filter2") && !transform.getURI().equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !transform.getURI().equals(XMLDSigNamespace.NS.getUri())) continue;
                            return SignaturePackaging.ENVELOPED;
                        }
                    }
                }
                catch (XMLSecurityException e) {
                    log.warn((Object)"error verificando transformaciones del xml", (Throwable)e);
                }
                if (DSSXMLUtils.isSignedProperties((Reference)reference, (XAdESPath)xades.getXAdESPaths()) || (objectById = xades.getObjectById(objectId = DomUtils.getId((String)reference.getURI()))) != null || objectId == null || objectId.isEmpty()) continue;
                return SignaturePackaging.DETACHED;
            }
            catch (DSSException e) {
                e.printStackTrace();
            }
        }
        return SignaturePackaging.ENVELOPING;
    }

    public XAdESSignature getSignature() {
        return (XAdESSignature)super.getSignature();
    }

    @Override
    public InputStream getSignedContent() {
        List references = this.getSignature().getReferences();
        if (!references.isEmpty()) {
            try {
                return new ByteArrayInputStream(((Reference)references.get(0)).getReferencedBytes());
            }
            catch (XMLSignatureException e) {
                log.error((Object)e);
            }
        }
        return null;
    }
}

