/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation.policy;

import com.anf.oauth.json.JSONFactory;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class ANFValidationPolicyFactory {
    private static final Logger log = LogManager.getLogger(ANFValidationPolicyFactory.class);
    private Set<String> notAllowedDigestAlg = Set.of("MD5", "SHA1");
    private ValidationPolicy validationPolicy;
    private static ValidationPolicy defaultPolicy = new ANFValidationPolicyFactory().build().getValidationPolicy();

    public static ValidationPolicy getDefaultPolicy() {
        return defaultPolicy;
    }

    public ANFValidationPolicyFactory build() {
        try {
            this.validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
        }
        catch (JAXBException | IOException | XMLStreamException | SAXException e) {
            throw new IllegalInputException("Unable to load the policy", e);
        }
        this.validationPolicy.getCryptographic().getAcceptableDigestAlgo().getAlgos().removeIf(alg -> this.notAllowedDigestAlg.contains(alg.getValue()));
        if (log.isInfoEnabled()) {
            log.info("validation policy: {}", (Object)JSONFactory.buildJSON((Object)this.validationPolicy));
        }
        return this;
    }

    public ValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }
}

