/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.validation;

import com.anf.cryptotoken.api.ocsp.CertStatus;
import com.anf.cryptotoken.api.ocsp.OCSPValidationResult;
import com.anf.cryptotoken.sign.validation.PolicyValidationResult;
import com.anf.cryptotoken.sign.validation.TimeStampData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SignatureResult {
    public String getId();

    public boolean isIntegrity();

    public X509Certificate[] getSigningCertificateChain();

    public List<CertStatus> getSigningCertificateChainStatus();

    public boolean isCoversWholeDocument();

    public List<Throwable> getErrors();

    public List<TimeStampData> getTsData();

    public void setOcspResult(OCSPValidationResult var1);

    public OCSPValidationResult getOcspResult();

    public boolean isQualifiedIssuer();

    public void setCoversWholeDocument(boolean var1);

    public void setIntegrity(boolean var1);

    public String getSignAlgorithm();

    public String getHashAlgorithm();

    public String getHashAlgorithmOid();

    public byte[] getContentHash();

    public String getEncryptionAlgorithm();

    public String getSignAlgorithmXmlId();

    public String getEncryptionAlgorithmOid();

    public String getHashAlgorithmXmlId();

    public Date getSigningTime();

    public String getFileName();

    public String getSignatureLevel();

    public String getScopeType();

    public SubIndication getValidationSubIndication();

    public Indication getValidationIndication();

    public PolicyValidationResult getPolicyValidation();

    public Set<String> getWarnings();

    public Set<String> getInfos();

    public SignaturePolicy getPolicy();

    public List<CommitmentTypeIndication> getCommitmentTypeIndications();

    public ByteRange getSignatureByteRange();

    public String getScope();

    public String getSignatureForm();

    public InputStream getSignedContent();

    public void validateSignatureResult();

    public boolean isModified();

    public int getModifications();

    public SignaturePackaging getSignaturePackaging();

    public X509Certificate getSignCert();

    public Indication getLongTermValidationIndication();

    public Map<String, String> getSemanticsMap();

    public DefaultAdvancedSignature getSignature();
}

