/*
 * Decompiled with CFR 0.152.
 */
package com.anf.cryptotoken.sign.policy;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ANFSignaturePolicyProvider
extends SignaturePolicyProvider {
    private static final Logger log = LogManager.getLogger(ANFSignaturePolicyProvider.class);
    CommonsDataLoader httpDataLoader = new CommonsDataLoader();
    private Set<String> knownPolicyUrls = new TreeSet<String>();
    Map<String, DSSDocument> signaturePoliciesByUrl = new HashMap<String, DSSDocument>();

    public ANFSignaturePolicyProvider() {
        this.httpDataLoader.setTimeoutConnection(30000);
        this.httpDataLoader.setTimeoutSocket(30000);
        this.httpDataLoader.setTimeoutResponse(3000);
        this.httpDataLoader.setTimeoutConnectionRequest(3000);
        this.setDataLoader((DataLoader)this.httpDataLoader);
        this.setSignaturePoliciesByUrl(this.signaturePoliciesByUrl);
    }

    public DSSDocument getSignaturePolicyByUrl(String url) {
        this.addUrl(url);
        return super.getSignaturePolicyByUrl(url);
    }

    private void addUrl(String url) {
        if (!this.knownPolicyUrls.contains(url)) {
            try {
                byte[] content = this.httpDataLoader.get(url);
                this.signaturePoliciesByUrl.put(url, (DSSDocument)new InMemoryDocument(content));
                this.knownPolicyUrls.add(url);
            }
            catch (Exception e) {
                log.error(String.format("error agregando url de politica: %s", url), (Throwable)e);
            }
        }
    }
}

