/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.HyphenationTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

public class Hyphenator {
    private static final String defaultHyphLocation = "com/lowagie/text/pdf/hyphenation/hyph/";
    private static Map<String, HyphenationTree> hyphenTrees = new Hashtable<String, HyphenationTree>();
    private static String hyphenDir = "";
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        String key = lang;
        if (country != null && !country.equals("none")) {
            key = key + "_" + country;
        }
        if (hyphenTrees.containsKey(key)) {
            return hyphenTrees.get(key);
        }
        if (hyphenTrees.containsKey(lang)) {
            return hyphenTrees.get(lang);
        }
        HyphenationTree hTree = Hyphenator.getResourceHyphenationTree(key);
        if (hTree == null) {
            hTree = Hyphenator.getFileHyphenationTree(key);
        }
        if (hTree != null) {
            hyphenTrees.put(key, hTree);
        }
        return hTree;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getResourceHyphenationTree(String key) {
        InputStream stream = Hyphenator.readHyphenationFile(key);
        if (stream == null) {
            return null;
        }
        try (InputStream resourceStream = stream;){
            HyphenationTree hTree = new HyphenationTree();
            hTree.loadSimplePatterns(stream);
            HyphenationTree hyphenationTree = hTree;
            return hyphenationTree;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static InputStream readHyphenationFile(String key) {
        InputStream stream = BaseFont.getResourceStream(defaultHyphLocation + key + ".xml");
        if (stream == null && key.length() > 2) {
            stream = BaseFont.getResourceStream(defaultHyphLocation + key.substring(0, 2) + ".xml");
        }
        return stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFileHyphenationTree(String key) {
        if (hyphenDir == null) {
            return null;
        }
        File hyphenFile = Hyphenator.getHyphenFile(key);
        if (hyphenFile == null) {
            return null;
        }
        try (FileInputStream stream = new FileInputStream(hyphenFile);){
            HyphenationTree hTree = new HyphenationTree();
            hTree.loadSimplePatterns(stream);
            HyphenationTree hyphenationTree = hTree;
            return hyphenationTree;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static File getHyphenFile(String key) {
        File hyphenFile = new File(hyphenDir, key + ".xml");
        if (hyphenFile.canRead()) {
            return hyphenFile;
        }
        if (key.length() > 2 && (hyphenFile = new File(hyphenDir, key.substring(0, 2) + ".xml")).canRead()) {
            return hyphenFile;
        }
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public static String getHyphenDir() {
        return hyphenDir;
    }

    public static void setHyphenDir(String _hyphenDir) {
        hyphenDir = _hyphenDir;
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }
}

