/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.context;

import io.datafx.controller.ViewConfiguration;
import io.datafx.controller.context.AbstractContext;
import io.datafx.controller.context.ApplicationContext;
import io.datafx.controller.context.ContextResolver;
import io.datafx.controller.context.ViewMetadata;
import io.datafx.controller.context.event.ContextDestroyedListener;
import io.datafx.core.DataFXUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javax.annotation.PreDestroy;

public class ViewContext<U>
extends AbstractContext {
    private Node rootNode;
    private U controller;
    private ContextResolver<U> resolver;
    private ViewConfiguration configuration;
    private ViewMetadata metadata;
    private ObservableList<ContextDestroyedListener<U>> contextDestroyedListeners;

    public ViewContext(Node rootNode, U controller, ViewMetadata metadata, ViewConfiguration configuration, Object ... resources) {
        this.rootNode = rootNode;
        this.controller = controller;
        this.configuration = configuration;
        this.metadata = metadata;
        this.contextDestroyedListeners = FXCollections.observableArrayList();
        if (resources != null) {
            for (Object resource : resources) {
                this.register(resource);
            }
        }
    }

    public ContextResolver<U> getResolver() {
        if (this.resolver == null) {
            this.resolver = new ContextResolver(this);
        }
        return this.resolver;
    }

    public U getController() {
        return this.controller;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public ApplicationContext getApplicationContext() {
        return ApplicationContext.getInstance();
    }

    public void destroy() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.controller != null) {
            for (Method method : DataFXUtils.getInheritedDeclaredMethods(this.getController().getClass())) {
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                DataFXUtils.callPrivileged((Method)method, this.getController(), (Object[])new Object[0]);
            }
        }
        for (ContextDestroyedListener listener : this.contextDestroyedListeners) {
            listener.contextDestroyed(this);
        }
    }

    public void addContextDestroyedListener(ContextDestroyedListener<U> listener) {
        this.contextDestroyedListeners.add(listener);
    }

    public void removeContextDestroyedListener(ContextDestroyedListener<U> listener) {
        this.contextDestroyedListeners.remove(listener);
    }

    public ViewConfiguration getConfiguration() {
        return this.configuration;
    }

    public ViewMetadata getMetadata() {
        return this.metadata;
    }
}

